/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.testing;

import com.softicar.platform.common.string.Imploder;
import java.util.ArrayList;
import java.util.Collection;

public class AssertionErrorMessageCollector {
    private final Collection<String> errorMessages = new ArrayList<String>();

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public AssertionErrorMessageCollector add(String message) {
        return this.add(message, new Object[0]);
    }

    public AssertionErrorMessageCollector addAll(Collection<String> messages) {
        messages.forEach(this::add);
        return this;
    }

    public AssertionErrorMessageCollector addAll(AssertionErrorMessageCollector other) {
        return this.addAll(other.getErrorMessages());
    }

    public AssertionErrorMessageCollector add(String message, Object ... args) {
        this.errorMessages.add(String.format(message, args));
        return this;
    }

    public void throwIfNecessary() {
        this.throwIfNecessary(null, new Object[0]);
    }

    public void throwIfNecessary(String descriptiveMessage, Object ... args) {
        if (!this.errorMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("Encountered %s errors: %s\n", this.errorMessages.size(), this.createDescription(descriptiveMessage, args)));
            message.append(Imploder.implode(this.errorMessages, (String)"\n"));
            throw new AssertionError((Object)message.toString());
        }
    }

    private String createDescription(String headerMessage, Object ... args) {
        if (headerMessage != null) {
            return String.format(headerMessage, args);
        }
        return "";
    }
}

