/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.testing;

import com.softicar.platform.common.container.iterable.Iterables;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.common.string.formatting.StackTraceFormatting;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Assert;

public class Asserts
extends Assert {
    public void assertEquals(int expectedValue, Integer actualValue) {
        Asserts.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    public <T> void assertSame(T expectedObject, Optional<T> optional) {
        Asserts.assertTrue((boolean)optional.isPresent());
        Asserts.assertSame(expectedObject, optional.get());
    }

    public static void assertThrows(Class<? extends Throwable> expectedThrowableClass, INullaryVoidFunction thrower) {
        Objects.requireNonNull(expectedThrowableClass);
        Objects.requireNonNull(thrower);
        Exception thrown = null;
        try {
            thrower.apply();
        }
        catch (Exception throwable) {
            thrown = throwable;
        }
        Asserts.assertNotNull((String)String.format("Expected a Throwable of class %s but none was thrown.", expectedThrowableClass.getCanonicalName()), (Object)thrown);
        Class<?> thrownClass = thrown.getClass();
        Asserts.assertTrue((String)String.format("Expected a Throwable of class %s but encountered a %s: %s", expectedThrowableClass.getCanonicalName(), thrownClass.getCanonicalName(), StackTraceFormatting.getStackTraceAsString((Throwable)thrown)), (boolean)expectedThrowableClass.isAssignableFrom(thrownClass));
    }

    public static <T> List<T> assertCount(int expectedCount, Iterable<T> objects, Predicate<T> predicate) {
        List<T> matchingObjects = Asserts.getMatchingObjects(objects, predicate);
        Asserts.assertEquals((long)expectedCount, (long)matchingObjects.size());
        return matchingObjects;
    }

    public static <T> List<T> assertCount(int expectedCount, Iterable<T> objects) {
        return Asserts.assertCount(expectedCount, objects, it -> true);
    }

    public static <T> T assertOne(Iterable<T> objects, Predicate<T> predicate) {
        return Asserts.assertCount(1, objects, predicate).get(0);
    }

    public static <T> void assertAny(Iterable<T> objects, Predicate<T> predicate) {
        List<T> matchingObjects = Asserts.getMatchingObjects(objects, predicate);
        Asserts.assertFalse((String)"None of the given objects satisfies the given predicate.", (boolean)matchingObjects.isEmpty());
    }

    public static <T> List<T> assertAll(Iterable<T> objects, Predicate<T> predicate) {
        Collection objectsCollection = Iterables.toCollection(objects);
        List<T> matchingObjects = Asserts.getMatchingObjects(objectsCollection, predicate);
        Asserts.assertEquals((String)"At least one of the given objects fails to satisfy the given predicate.", (long)objectsCollection.size(), (long)matchingObjects.size());
        return matchingObjects;
    }

    public static <T> T assertOne(Iterable<T> objects) {
        return Asserts.assertCount(1, objects).get(0);
    }

    public static <T> void assertNone(Iterable<T> objects) {
        Asserts.assertCount(0, objects);
    }

    public static void assertRegex(String regex, String fullText) {
        boolean matches = Pattern.compile(regex, 32).matcher(fullText).matches();
        if (!matches) {
            throw new AssertionError((Object)String.format("The string '%s' does not match regular expression '%s'.", fullText, regex));
        }
    }

    public static void assertContains(String substring, String fullText) {
        if (!fullText.contains(substring)) {
            throw new AssertionError((Object)String.format("Failed to find substring '%s' in '%s'.", substring, fullText));
        }
    }

    public static void assertStartsWith(String start, String fullText) {
        if (!fullText.startsWith(start)) {
            throw new AssertionError((Object)String.format("Failed to find '%s' at beginning of '%s'.", start, fullText));
        }
    }

    private static <T> List<T> getMatchingObjects(Iterable<T> objects, Predicate<T> predicate) {
        return Iterables.toStream(objects).filter(predicate).collect(Collectors.toList());
    }
}

