/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.color;

import com.softicar.platform.common.ui.color.IColor;
import com.softicar.platform.common.ui.color.RgbColor;

public class HslColor
implements IColor {
    private final double hue;
    private final double saturation;
    private final double lightness;
    private final double alpha;

    public HslColor(RgbColor rgbColor) {
        double r = rgbColor.getRedNormalized();
        double g = rgbColor.getGreenNormalized();
        double b = rgbColor.getBlueNormalized();
        double M = HslColor.maxValue(r, g, b);
        double m = HslColor.minValue(r, g, b);
        double C = M - m;
        this.hue = HslColor.computeHue(M, C, r, g, b);
        this.lightness = HslColor.computeLightness(M, m);
        this.saturation = HslColor.computeSaturation(C, this.lightness);
        this.alpha = 1.0;
    }

    public HslColor(double hue, double saturation, double lightness) {
        this(hue, saturation, lightness, 1.0);
    }

    public HslColor(double hue, double saturation, double lightness, double alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.lightness = lightness;
        this.alpha = alpha;
        if (hue < 0.0 || hue > 360.0) {
            throw new IllegalArgumentException(String.format("Illegal hue value %s. Must be in the range [0, 360].", hue));
        }
        if (saturation < 0.0 || saturation > 1.0) {
            throw new IllegalArgumentException(String.format("Illegal saturation value %s. Must be in the range [0, 1].", saturation));
        }
        if (lightness < 0.0 || lightness > 1.0) {
            throw new IllegalArgumentException(String.format("Illegal lightness value %s. Must be in the range [0, 1].", lightness));
        }
    }

    public double getHue() {
        return this.hue;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public double getLightness() {
        return this.lightness;
    }

    public int getRgbValue() {
        return this.getRgbColor().getRgbValue();
    }

    public RgbColor getRgbColor() {
        double h2 = this.hue / 60.0;
        double c = (1.0 - Math.abs(2.0 * this.lightness - 1.0)) * this.saturation;
        double x = c * (1.0 - Math.abs(h2 % 2.0 - 1.0));
        double m = this.lightness - c / 2.0;
        if (h2 < 1.0) {
            return this.getRgbColor(m, c, x, 0.0);
        }
        if (h2 < 2.0) {
            return this.getRgbColor(m, x, c, 0.0);
        }
        if (h2 < 3.0) {
            return this.getRgbColor(m, 0.0, c, x);
        }
        if (h2 < 4.0) {
            return this.getRgbColor(m, 0.0, x, c);
        }
        if (h2 < 5.0) {
            return this.getRgbColor(m, x, 0.0, c);
        }
        return this.getRgbColor(m, c, 0.0, x);
    }

    @Override
    public String toHtml() {
        int h = (int)Math.round(this.hue);
        int s = (int)Math.round(this.saturation * 100.0);
        int l = (int)Math.round(this.lightness * 100.0);
        if (this.alpha == 1.0) {
            return String.format("hsl(%s,%s%%,%s%%)", h, s, l);
        }
        return String.format("hsla(%s,%s%%,%s%%,%s)", h, s, l, this.alpha);
    }

    private RgbColor getRgbColor(double m, double r1, double g1, double b1) {
        return new RgbColor(r1 + m, g1 + m, b1 + m);
    }

    private static double computeHue(double M, double C, double red, double green, double blue) {
        if (C == 0.0) {
            return 0.0;
        }
        if (M == red) {
            return 60.0 * HslColor.mod((green - blue) / C, 6.0);
        }
        if (M == green) {
            return 60.0 * ((blue - red) / C + 2.0);
        }
        return 60.0 * ((red - green) / C + 4.0);
    }

    private static double computeLightness(double M, double m) {
        return (M + m) / 2.0;
    }

    private static double computeSaturation(double C, double lightness) {
        double divisor = 1.0 - Math.abs(2.0 * lightness - 1.0);
        return divisor != 0.0 ? C / divisor : 0.0;
    }

    private static double maxValue(double red, double green, double blue) {
        return Math.max(red, Math.max(green, blue));
    }

    private static double minValue(double red, double green, double blue) {
        return Math.min(red, Math.min(green, blue));
    }

    private static double mod(double value, double divisor) {
        double result = value % divisor;
        return result >= 0.0 ? result : result + divisor;
    }
}

