/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.color;

import com.softicar.platform.common.math.Clamping;
import com.softicar.platform.common.string.Padding;
import com.softicar.platform.common.ui.color.IColor;
import java.util.Objects;

public class RgbColor
implements IColor {
    private final int rgbValue;

    public RgbColor(int rgbValue) {
        this.rgbValue = rgbValue;
        if (rgbValue < 0 || rgbValue > 0xFFFFFF) {
            throw new IllegalArgumentException(String.format("Value of color value must be in the range [0, 0xFFFFFF] but is %s.", Integer.toHexString(rgbValue)));
        }
    }

    public RgbColor(int red, int green, int blue) {
        this(RgbColor.getColorValue(red, green, blue));
    }

    public RgbColor(double red, double green, double blue) {
        this(RgbColor.getChannelAsInt(red), RgbColor.getChannelAsInt(green), RgbColor.getChannelAsInt(blue));
    }

    public static RgbColor parseHtmlCode(String htmlCode) {
        if (htmlCode.length() == 7 && htmlCode.charAt(0) == '#') {
            int colorValue = Integer.parseInt(htmlCode.substring(1), 16);
            return new RgbColor(colorValue);
        }
        throw new IllegalArgumentException(String.format("Illegal HTML color code '%s'.", htmlCode));
    }

    public int getRgbValue() {
        return this.rgbValue & 0xFFFFFF;
    }

    public int getRed() {
        return this.rgbValue >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.rgbValue >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.rgbValue & 0xFF;
    }

    public double getRedNormalized() {
        return (double)this.getRed() / 255.0;
    }

    public double getGreenNormalized() {
        return (double)this.getGreen() / 255.0;
    }

    public double getBlueNormalized() {
        return (double)this.getBlue() / 255.0;
    }

    @Override
    public String toHtml() {
        String hex = Integer.toHexString(this.rgbValue).toUpperCase();
        return "#" + Padding.padLeft((String)hex, (char)'0', (int)6);
    }

    public int hashCode() {
        return Objects.hash(this.rgbValue);
    }

    public boolean equals(Object other) {
        if (other instanceof RgbColor) {
            return this.rgbValue == ((RgbColor)other).rgbValue;
        }
        return false;
    }

    private static int getChannelAsInt(double channel) {
        RgbColor.checkChannel(channel);
        int channelValue = (int)Math.round(channel * 255.0);
        return Clamping.clamp((int)0, (int)255, (int)channelValue);
    }

    private static int getColorValue(int red, int green, int blue) {
        RgbColor.checkChannel(red);
        RgbColor.checkChannel(green);
        RgbColor.checkChannel(blue);
        return (red << 16) + (green << 8) + blue;
    }

    private static void checkChannel(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException(String.format("Value of color channel must be in the range [0, 255] but is %d.", value));
        }
    }

    private static void checkChannel(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException(String.format("Value of color channel must be in the range [0.0, 1.0] but is %.3f.", value));
        }
    }
}

