/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.refresh;

import com.softicar.platform.common.core.interfaces.IRefreshable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MultiRefreshable
implements IRefreshable {
    private final List<IRefreshable> refreshables = new ArrayList<IRefreshable>();

    public MultiRefreshable(IRefreshable ... refreshables) {
        if (refreshables != null) {
            this.addRefreshables(Arrays.asList(refreshables));
        }
    }

    public MultiRefreshable(Collection<IRefreshable> refreshables) {
        this.addRefreshables(refreshables);
    }

    public void refresh() {
        for (IRefreshable refreshable : this.refreshables) {
            if (refreshable == null) continue;
            refreshable.refresh();
        }
    }

    public MultiRefreshable addRefreshable(IRefreshable refreshable) {
        if (refreshable != null && !this.refreshables.contains(refreshable)) {
            this.refreshables.add(refreshable);
        }
        return this;
    }

    public MultiRefreshable addRefreshables(Collection<IRefreshable> refreshables) {
        if (refreshables != null) {
            for (IRefreshable refreshable : refreshables) {
                this.addRefreshable(refreshable);
            }
        }
        return this;
    }

    public MultiRefreshable addRefreshables(IRefreshable ... refreshables) {
        this.addRefreshables(Arrays.asList(refreshables));
        return this;
    }

    public MultiRefreshable removeRefreshable(IRefreshable refreshable) {
        this.refreshables.remove(refreshable);
        return this;
    }

    public MultiRefreshable removeRefreshables(Collection<IRefreshable> refreshables) {
        if (refreshables != null) {
            for (IRefreshable refreshable : refreshables) {
                this.removeRefreshable(refreshable);
            }
        }
        return this;
    }

    public MultiRefreshable removeRefreshables(IRefreshable ... refreshables) {
        this.removeRefreshables(Arrays.asList(refreshables));
        return this;
    }
}

