/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki;

import com.softicar.platform.common.string.scanning.ISimpleTextMatcher;
import com.softicar.platform.common.string.scanning.ISimpleTextScannerCallback;
import com.softicar.platform.common.string.scanning.SimpleTextScanner;
import com.softicar.platform.common.ui.wiki.ISimpleWikiParserCallback;
import com.softicar.platform.common.ui.wiki.SimpleWikiParserEngine;
import com.softicar.platform.common.ui.wiki.matchers.WikiParserBoldMatcher;
import com.softicar.platform.common.ui.wiki.matchers.WikiParserColorMatcher;
import com.softicar.platform.common.ui.wiki.matchers.WikiParserHeadlineMatcher;
import com.softicar.platform.common.ui.wiki.matchers.WikiParserItalicMatcher;
import com.softicar.platform.common.ui.wiki.matchers.WikiParserListMatcher;
import com.softicar.platform.common.ui.wiki.matchers.WikiParserNewLineMatcher;
import com.softicar.platform.common.ui.wiki.matchers.WikiParserNewParagraphMatcher;

public class SimpleWikiParser {
    private final SimpleWikiParserEngine engine;
    private final SimpleTextScanner scanner;
    private final WikiParserListMatcher listMatcher;

    public SimpleWikiParser(ISimpleWikiParserCallback callback) {
        this.engine = new SimpleWikiParserEngine(callback);
        this.scanner = new SimpleTextScanner((ISimpleTextScannerCallback)this.engine);
        this.listMatcher = new WikiParserListMatcher(this.engine);
        this.scanner.addMatcher((ISimpleTextMatcher)new WikiParserBoldMatcher(this.engine));
        this.scanner.addMatcher((ISimpleTextMatcher)new WikiParserItalicMatcher(this.engine));
        this.scanner.addMatcher((ISimpleTextMatcher)new WikiParserColorMatcher(callback));
        this.scanner.addMatcher((ISimpleTextMatcher)new WikiParserNewLineMatcher(callback));
        this.scanner.addMatcher((ISimpleTextMatcher)new WikiParserNewParagraphMatcher(this.engine));
        this.scanner.addMatcher((ISimpleTextMatcher)new WikiParserHeadlineMatcher(this.engine));
        this.scanner.addMatcher((ISimpleTextMatcher)this.listMatcher);
    }

    public void parseLine(String line) {
        this.scanner.scan(line);
        this.scanner.scan("\n");
    }

    public void parseText(String text) {
        this.scanner.scan(text);
    }

    public void flush() {
        this.engine.flush();
    }
}

