/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki;

import com.softicar.platform.common.string.scanning.ISimpleTextScannerCallback;
import com.softicar.platform.common.ui.wiki.ISimpleWikiParserCallback;
import java.util.Stack;

public class SimpleWikiParserEngine
implements ISimpleTextScannerCallback {
    private final ISimpleWikiParserCallback callback;
    private final Stack<String> listStack;
    private boolean inListItem;
    private boolean inParagraph;
    private boolean inHeadline;
    private boolean inSection;

    public SimpleWikiParserEngine(ISimpleWikiParserCallback callback) {
        this.callback = callback;
        this.listStack = new Stack();
        this.inListItem = false;
        this.inParagraph = false;
        this.inHeadline = false;
        this.inSection = false;
    }

    public void consumeNormalText(String text) {
        this.endAllListsIfNecessary();
        this.beginParagraphIfNecessary();
        this.callback.addText(text);
    }

    public void consumeWhitespace(String whitespace) {
        this.endAllListsIfNecessary();
        this.beginParagraphIfNecessary();
        this.callback.addWhitespace(whitespace);
    }

    public void flush() {
        this.endListItemAndAllLists();
        this.endParagraphIfNecessary();
        this.endSectionIfNecessary();
    }

    public void endParagraph() {
        this.endParagraphIfNecessary();
    }

    private void beginParagraphIfNecessary() {
        if (!(this.inParagraph || this.inHeadline || this.inListItem)) {
            this.callback.beginParagraph();
            this.inParagraph = true;
        }
    }

    private void endAllListsIfNecessary() {
        if (this.isInList() && !this.inListItem) {
            this.endAllLists();
        }
    }

    private void endParagraphIfNecessary() {
        if (this.inParagraph) {
            this.callback.endParagraph();
            this.inParagraph = false;
        }
    }

    private void endSectionIfNecessary() {
        if (this.inSection) {
            this.callback.endSection();
            this.inSection = false;
        }
    }

    public void beginHeadLine(int level) {
        this.endListItemAndAllLists();
        this.endParagraphIfNecessary();
        this.endSectionIfNecessary();
        this.callback.beginSection(level);
        this.inSection = true;
        this.callback.beginHeadLine(level);
        this.inHeadline = true;
    }

    public void endHeadLine(int level) {
        this.callback.endHeadLine(level);
        this.inHeadline = false;
    }

    public void beginBold() {
        this.endAllListsIfNecessary();
        this.beginParagraphIfNecessary();
        this.callback.beginBold();
    }

    public void endBold() {
        this.callback.endBold();
    }

    public void beginItalic() {
        this.endAllListsIfNecessary();
        this.beginParagraphIfNecessary();
        this.callback.beginItalic();
    }

    public void endItalic() {
        this.callback.endItalic();
    }

    public String getCurrentList() {
        return this.listStack.isEmpty() ? null : this.listStack.peek();
    }

    public boolean isInList() {
        return !this.listStack.isEmpty();
    }

    public void beginList(String text) {
        this.listStack.push(text);
        if (text.trim().equals("*")) {
            this.callback.beginUnorderedList();
        } else {
            this.callback.beginOrderedList();
        }
    }

    public void endCurrentList() {
        if (this.listStack.peek().trim().equals("*")) {
            this.callback.endUnorderedList();
        } else {
            this.callback.endOrderedList();
        }
        this.listStack.pop();
    }

    public void endListItemAndAllLists() {
        this.endListItem();
        this.endAllLists();
    }

    private void endAllLists() {
        while (!this.listStack.isEmpty()) {
            this.endCurrentList();
        }
    }

    public void beginListItem() {
        if (!this.inListItem) {
            this.callback.beginListItem();
            this.inListItem = true;
        }
    }

    public void endListItem() {
        if (this.inListItem) {
            this.callback.endListItem();
            this.inListItem = false;
        }
    }
}

