/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki;

import com.softicar.platform.common.ui.color.IColor;
import com.softicar.platform.common.ui.wiki.ISimpleWikiParserCallback;

public class SimpleWikiParserHtmlCallback
implements ISimpleWikiParserCallback {
    private final StringBuilder html = new StringBuilder();

    public String getHtml() {
        return this.html.toString();
    }

    public void clear() {
        this.html.setLength(0);
    }

    @Override
    public void addText(String text) {
        this.html.append(text);
    }

    @Override
    public void addWhitespace(String whitespace) {
        this.html.append(" ");
    }

    @Override
    public void addNewLine() {
        this.html.append("<br>");
    }

    @Override
    public void beginParagraph() {
        this.html.append("<p>");
    }

    @Override
    public void endParagraph() {
        this.html.append("</p>");
    }

    @Override
    public void beginBold() {
        this.html.append("<b>");
    }

    @Override
    public void endBold() {
        this.html.append("</b>");
    }

    @Override
    public void beginItalic() {
        this.html.append("<i>");
    }

    @Override
    public void endItalic() {
        this.html.append("</i>");
    }

    @Override
    public void beginColor(IColor color) {
        this.html.append(String.format("<span style='color: %s'>", color.toHtml()));
    }

    @Override
    public void endColor() {
        this.html.append("</span>");
    }

    @Override
    public void beginHeadLine(int level) {
        this.html.append(String.format("<h%s>", level));
    }

    @Override
    public void endHeadLine(int level) {
        this.html.append(String.format("</h%s>", level));
    }

    @Override
    public void beginUnorderedList() {
        this.html.append("<ul>");
    }

    @Override
    public void endUnorderedList() {
        this.html.append("</ul>");
    }

    @Override
    public void beginOrderedList() {
        this.html.append("<ol>");
    }

    @Override
    public void endOrderedList() {
        this.html.append("</ol>");
    }

    @Override
    public void beginListItem() {
        this.html.append("<li>");
    }

    @Override
    public void endListItem() {
        this.html.append("</li>");
    }

    @Override
    public void beginSection(int level) {
        this.html.append("<div>");
    }

    @Override
    public void endSection() {
        this.html.append("</div>");
    }
}

