/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.element;

import com.softicar.platform.common.ui.wiki.element.AbstractWikiElement;
import com.softicar.platform.common.ui.wiki.element.IWikiElement;
import com.softicar.platform.common.ui.wiki.element.IWikiParentElement;
import com.softicar.platform.common.ui.wiki.element.block.WikiList;
import com.softicar.platform.common.ui.wiki.element.block.WikiListItem;
import com.softicar.platform.common.ui.wiki.element.block.WikiParagraph;
import com.softicar.platform.common.ui.wiki.element.block.WikiTable;
import com.softicar.platform.common.ui.wiki.element.block.WikiTableRow;
import com.softicar.platform.common.ui.wiki.element.inline.WikiText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractWikiParentElement
extends AbstractWikiElement
implements IWikiParentElement {
    private final List<IWikiElement> children = new ArrayList<IWikiElement>();

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.children.stream().map(Object::toString).collect(Collectors.joining(" ")) + ")";
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public IWikiElement getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public Collection<IWikiElement> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(IWikiElement child) {
        if (child instanceof WikiListItem && !(this instanceof WikiList)) {
            WikiListItem listItem = (WikiListItem)child;
            this.getOrAddChildOfType(WikiList.class, () -> new WikiList(listItem), list -> list.isCompatible(listItem)).addChild(child);
        } else if (child instanceof WikiTableRow && !(this instanceof WikiTable)) {
            this.getOrAddChildOfType(WikiTable.class, () -> new WikiTable()).addChild(child);
        } else {
            this.children.add(child);
        }
    }

    @Override
    public void cleanup() {
        this.getChildren().stream().filter(IWikiParentElement.class::isInstance).map(IWikiParentElement.class::cast).forEach(IWikiParentElement::cleanup);
        if (this.isBlockElement()) {
            this.trimWhitespace();
            this.dropEmtpyElements();
        }
    }

    protected <E extends IWikiElement> E getOrAddChildOfType(Class<E> elementClass, Supplier<E> factory) {
        return (E)this.getOrAddChildOfType(elementClass, factory, element -> true);
    }

    protected <E extends IWikiElement> E getOrAddChildOfType(Class<E> elementClass, Supplier<E> factory, Predicate<E> predicate) {
        IWikiElement element;
        IWikiElement child;
        if (this.size() > 0 && elementClass.isInstance(child = this.getChild(this.size() - 1)) && predicate.test(element = (IWikiElement)elementClass.cast(child))) {
            return (E)element;
        }
        child = (IWikiElement)factory.get();
        this.children.add(child);
        return (E)child;
    }

    private void trimWhitespace() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            IWikiElement child = this.children.get(i);
            if (!(child instanceof WikiText)) continue;
            if (i == 0 || this.children.get(i - 1).isBlockElement()) {
                ((WikiText)child).trimLeft();
            }
            if (i != n - 1 && !this.children.get(i + 1).isBlockElement()) continue;
            ((WikiText)child).trimRight();
        }
    }

    private void dropEmtpyElements() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            if (!this.isEmpty(this.children.get(i))) continue;
            this.children.remove(i);
            --n;
        }
    }

    private boolean isEmpty(IWikiElement element) {
        if (element instanceof WikiText) {
            return ((WikiText)element).getText().isEmpty();
        }
        if (element instanceof WikiParagraph) {
            return ((WikiParagraph)element).size() == 0;
        }
        return false;
    }
}

