/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.element.inline;

class WikiWhitespaceNormalizer {
    private final String text;
    private StringBuilder builder;
    private boolean whitespace;

    public WikiWhitespaceNormalizer(String text) {
        this.text = text;
    }

    public String getNormalized() {
        this.builder = new StringBuilder();
        this.whitespace = false;
        for (int i = 0; i < this.text.length(); ++i) {
            char character = this.text.charAt(i);
            if (Character.isWhitespace(character)) {
                this.appendWhitespace();
                continue;
            }
            this.appendNonWhitespace(character);
        }
        return this.builder.toString();
    }

    private void appendWhitespace() {
        if (!this.whitespace) {
            this.builder.append(' ');
            this.whitespace = true;
        }
    }

    private void appendNonWhitespace(char character) {
        this.builder.append(character);
        this.whitespace = false;
    }
}

