/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.element.parser;

import com.softicar.platform.common.ui.wiki.element.IWikiElement;
import com.softicar.platform.common.ui.wiki.element.IWikiParentElement;
import com.softicar.platform.common.ui.wiki.element.parser.WikiElementParser;
import com.softicar.platform.common.ui.wiki.element.parser.WikiElementParserFactory;
import com.softicar.platform.common.ui.wiki.parser.WikiTokenStream;
import com.softicar.platform.common.ui.wiki.token.WikiToken;
import com.softicar.platform.common.ui.wiki.token.WikiTokenType;
import java.util.Set;
import java.util.TreeSet;

public class WikiParentElementParser<E extends IWikiParentElement>
extends WikiElementParser<E> {
    private final Set<WikiTokenType> childTokenTypes = new TreeSet<WikiTokenType>();

    public WikiParentElementParser(E element) {
        super(element);
    }

    @Override
    public E parse(WikiTokenStream tokenStream) {
        while (tokenStream.hasToken()) {
            WikiToken token = tokenStream.getToken();
            if (this.endTokenMatcher.test(token)) {
                tokenStream.consumeToken();
                break;
            }
            if (!this.isChildToken(token)) break;
            tokenStream.consumeToken();
            ((IWikiParentElement)this.element).addChild((IWikiElement)WikiElementParserFactory.getInstance().createParser(token).parse(tokenStream));
        }
        return (E)((IWikiParentElement)this.element);
    }

    protected boolean isChildToken(WikiToken token) {
        if (token.isCloseTag()) {
            return false;
        }
        return this.childTokenTypes.contains((Object)token.getTokenType());
    }

    protected void addChildTokenType(WikiTokenType childTokenType) {
        this.childTokenTypes.add(childTokenType);
    }
}

