/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.element.tag;

import com.softicar.platform.common.ui.wiki.element.parser.IWikiElementParser;
import com.softicar.platform.common.ui.wiki.element.tag.WikiBox;
import com.softicar.platform.common.ui.wiki.element.tag.WikiBoxParser;
import com.softicar.platform.common.ui.wiki.element.tag.WikiBoxType;
import com.softicar.platform.common.ui.wiki.element.tag.WikiRawTextParser;
import com.softicar.platform.common.ui.wiki.element.tag.WikiRawTextType;
import com.softicar.platform.common.ui.wiki.token.WikiTag;
import com.softicar.platform.common.ui.wiki.token.WikiTagToken;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public class WikiTagElementParserFactory {
    private static final WikiTagElementParserFactory INSTANCE = new WikiTagElementParserFactory();
    private final Map<WikiTag, Function<WikiTagToken, IWikiElementParser<?>>> factories = new TreeMap();

    public WikiTagElementParserFactory() {
        this.factories.put(WikiTag.CODE, token -> new WikiRawTextParser(WikiRawTextType.CODE));
        this.factories.put(WikiTag.ERROR, token -> new WikiBoxParser(new WikiBox(WikiBoxType.ERROR)));
        this.factories.put(WikiTag.INFO, token -> new WikiBoxParser(new WikiBox(WikiBoxType.INFO)));
        this.factories.put(WikiTag.PRE, token -> new WikiRawTextParser(WikiRawTextType.PRE));
        this.factories.put(WikiTag.WARNING, token -> new WikiBoxParser(new WikiBox(WikiBoxType.WARNING)));
    }

    public static WikiTagElementParserFactory getInstance() {
        return INSTANCE;
    }

    public IWikiElementParser<?> createParser(WikiTagToken token) {
        return this.factories.get((Object)token.getTag()).apply(token);
    }
}

