/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.matchers;

import com.softicar.platform.common.string.scanning.AbstractLiteralMatcher;
import com.softicar.platform.common.ui.wiki.SimpleWikiParserEngine;

public class WikiParserHeadlineMatcher
extends AbstractLiteralMatcher {
    private final SimpleWikiParserEngine engine;
    private boolean headline;

    public WikiParserHeadlineMatcher(SimpleWikiParserEngine engine) {
        this.engine = engine;
        this.headline = false;
        this.addLiteral("======");
        this.addLiteral("=====");
        this.addLiteral("====");
        this.addLiteral("===");
        this.addLiteral("==");
    }

    protected void consumeLiteral(String literal) {
        this.headline = !this.headline;
        int level = 7 - literal.length();
        if (this.headline) {
            this.engine.beginHeadLine(level);
        } else {
            this.engine.endHeadLine(level);
        }
    }
}

