/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.matchers;

import com.softicar.platform.common.string.scanning.ISimpleTextMatcher;
import com.softicar.platform.common.ui.wiki.SimpleWikiParserEngine;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiParserListMatcher
implements ISimpleTextMatcher {
    private static final Pattern LIST_PREFIX_PATTERN = Pattern.compile("  [ ]*[\\*-]\\s+");
    private final SimpleWikiParserEngine engine;

    public WikiParserListMatcher(SimpleWikiParserEngine engine) {
        this.engine = engine;
    }

    public int getMatchingLength(String text) {
        Matcher matcher = LIST_PREFIX_PATTERN.matcher(text);
        if (matcher.lookingAt()) {
            return matcher.group().length();
        }
        if (this.engine.isInList() && text.startsWith("\n")) {
            return 1;
        }
        return 0;
    }

    public void consumeMatchingText(String text) {
        if (text.equals("\n")) {
            this.engine.endListItem();
        } else {
            while (!Objects.equals(this.engine.getCurrentList(), text)) {
                String top = this.engine.getCurrentList();
                if (top == null || top.length() < text.length()) {
                    this.engine.beginList(text);
                    continue;
                }
                if (top.length() < text.length()) continue;
                this.engine.endCurrentList();
            }
            this.engine.beginListItem();
        }
    }
}

