/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.token;

import com.softicar.platform.common.ui.wiki.token.WikiToken;
import com.softicar.platform.common.ui.wiki.token.WikiTokenType;
import java.util.ArrayList;
import java.util.Collection;

public class WikiTableRowToken
extends WikiToken {
    private final Collection<Cell> cells;

    public WikiTableRowToken(String text) {
        super(WikiTokenType.TABLE_ROW, text);
        this.cells = new CellsParser(text).parse();
    }

    public Collection<Cell> getCells() {
        return this.cells;
    }

    private class CellsParser {
        private final String text;
        private final Collection<Cell> parsedCells;
        private StringBuilder builder;
        private boolean header;

        public CellsParser(String text) {
            this.text = text.trim();
            this.parsedCells = new ArrayList<Cell>();
        }

        public Collection<Cell> parse() {
            this.header = false;
            this.builder = new StringBuilder();
            for (int i = 0; i < this.text.length(); ++i) {
                char character = this.text.charAt(i);
                if (character == '^' || character == '|') {
                    this.finishCell();
                    this.header = character == '^';
                    continue;
                }
                this.builder.append(character);
            }
            this.finishCell();
            return this.parsedCells;
        }

        private void finishCell() {
            if (this.builder.length() > 0) {
                this.parsedCells.add(new Cell(this.builder.toString().trim(), this.header));
                this.builder = new StringBuilder();
            }
        }
    }

    public static class Cell {
        private final String text;
        private final boolean header;

        public Cell(String text, boolean header) {
            this.text = text;
            this.header = header;
        }

        public String getText() {
            return this.text;
        }

        public boolean isHeader() {
            return this.header;
        }
    }
}

