/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.token;

import com.softicar.platform.common.core.utils.DevNull;
import com.softicar.platform.common.ui.wiki.token.WikiTag;
import com.softicar.platform.common.ui.wiki.token.WikiTokenType;
import java.util.Objects;

public class WikiToken {
    private final WikiTokenType tokenType;
    private final String consumedText;

    public WikiToken(WikiTokenType tokenType, String consumedText) {
        this.tokenType = tokenType;
        this.consumedText = consumedText;
    }

    public WikiTokenType getTokenType() {
        return this.tokenType;
    }

    public String getConsumedText() {
        return this.consumedText;
    }

    public boolean isCloseTag() {
        return false;
    }

    public boolean isCloseTag(WikiTag tag) {
        DevNull.swallow((Object)((Object)tag));
        return false;
    }

    public boolean isWhiteSpace() {
        if (this.tokenType == WikiTokenType.TEXT) {
            for (int i = 0; i < this.consumedText.length(); ++i) {
                if (Character.isWhitespace(this.consumedText.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tokenType, this.consumedText});
    }

    public boolean equals(Object object) {
        if (object instanceof WikiToken) {
            WikiToken other = (WikiToken)object;
            return Objects.equals((Object)this.tokenType, (Object)other.tokenType) && Objects.equals(this.consumedText, other.consumedText);
        }
        return false;
    }
}

