/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.ui.wiki.tokenizer;

import com.softicar.platform.common.ui.wiki.token.WikiToken;
import com.softicar.platform.common.ui.wiki.token.WikiTokenType;
import com.softicar.platform.common.ui.wiki.token.matcher.IWikiTokenMatcher;
import com.softicar.platform.common.ui.wiki.token.matcher.MainWikiTokenMatcher;
import com.softicar.platform.common.ui.wiki.tokenizer.IWikiTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;

public class WikiTokenizer
implements IWikiTokenizer {
    private final String wikiText;
    private final Stack<IWikiTokenMatcher> matcherStack;
    private final List<WikiToken> tokens;
    private StringBuilder plainText;
    private int index;

    public WikiTokenizer(String wikiText) {
        this.wikiText = wikiText;
        this.matcherStack = new Stack();
        this.matcherStack.push(new MainWikiTokenMatcher());
        this.tokens = new ArrayList<WikiToken>();
        this.plainText = new StringBuilder();
        this.index = 0;
    }

    public List<WikiToken> tokenize() {
        int length = this.wikiText.length();
        while (this.index < length) {
            if (this.matcherStack.peek().match(this)) continue;
            this.addPlainText(this.wikiText.charAt(this.index));
        }
        this.flushPlainText();
        return this.tokens;
    }

    @Override
    public int getLength() {
        return this.wikiText.length() - this.index;
    }

    @Override
    public boolean startsWith(String pattern) {
        return this.wikiText.startsWith(pattern, this.index);
    }

    @Override
    public Optional<Integer> findIndexOf(String pattern) {
        for (int i = this.index; i < this.wikiText.length(); ++i) {
            if (!this.wikiText.startsWith(pattern, i)) continue;
            return Optional.of(i - this.index);
        }
        return Optional.empty();
    }

    @Override
    public int findIndexOf(char character, int offset) {
        for (int i = this.index + offset; i < this.wikiText.length(); ++i) {
            if (this.wikiText.charAt(i) != character) continue;
            return i - this.index;
        }
        return -1;
    }

    @Override
    public int findIndexOfOther(char character, int offset) {
        for (int i = this.index + offset; i < this.wikiText.length(); ++i) {
            if (this.wikiText.charAt(i) == character) continue;
            return i - this.index;
        }
        return this.wikiText.length() - this.index;
    }

    @Override
    public String getSubstring(int beginOffset, int endOffset) {
        return this.wikiText.substring(this.index + beginOffset, this.index + endOffset);
    }

    @Override
    public char getCharAt(int offset, char fallback) {
        int i = this.index + offset;
        return i >= 0 && i < this.wikiText.length() ? this.wikiText.charAt(i) : fallback;
    }

    @Override
    public void addToken(WikiToken token) {
        this.flushPlainText();
        this.tokens.add(token);
        this.index += token.getConsumedText().length();
    }

    private void addPlainText(char character) {
        this.plainText.append(character);
        ++this.index;
    }

    private void flushPlainText() {
        if (this.plainText.length() > 0) {
            this.tokens.add(new WikiToken(WikiTokenType.TEXT, this.plainText.toString()));
            this.plainText = new StringBuilder();
        }
    }
}

