/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.attribute;

import com.softicar.platform.common.core.utils.CompareUtils;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.utils.JavascriptEscaping;

public class DomAttribute
implements IDomAttribute {
    private final int m_hash;
    private final String m_name;
    private final String m_value;
    private final boolean m_mustBeQuoted;

    public DomAttribute(String name, String value, boolean mustBeQuoted) {
        this.m_name = name.toLowerCase();
        this.m_value = value;
        this.m_mustBeQuoted = mustBeQuoted;
        this.m_hash = this.m_name.hashCode() + (this.m_value != null ? this.m_value.hashCode() : 0) + Boolean.valueOf(this.m_mustBeQuoted).hashCode();
    }

    @Override
    public int compareTo(IDomAttribute other) {
        int cmp1 = this.getName().compareTo(other.getName());
        if (cmp1 != 0) {
            return cmp1;
        }
        int cmp2 = this.getValue().compareTo(other.getValue());
        if (cmp2 != 0) {
            return cmp2;
        }
        int cmp3 = (this.mustBeQuoted() ? 1 : 0) - (other.mustBeQuoted() ? 1 : 0);
        if (cmp3 != 0) {
            return cmp3;
        }
        return 0;
    }

    public String toString() {
        return String.format("%s: %s", this.getName(), this.getValue_JS());
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getValue() {
        return this.m_value;
    }

    @Override
    public String getValue_JS() {
        return this.m_mustBeQuoted ? "'" + JavascriptEscaping.getEscaped(this.m_value) + "'" : this.m_value;
    }

    @Override
    public boolean mustBeQuoted() {
        return this.m_mustBeQuoted;
    }

    public int hashCode() {
        return this.m_hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DomAttribute) {
            DomAttribute otherAttribute = (DomAttribute)other;
            return this.m_hash == otherAttribute.m_hash && CompareUtils.isEqual((Object)this.m_name, (Object)otherAttribute.m_name) && CompareUtils.isEqual((Object)this.m_value, (Object)otherAttribute.m_value) && this.m_mustBeQuoted == otherAttribute.m_mustBeQuoted;
        }
        return false;
    }
}

