/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.attribute;

import com.softicar.platform.common.string.Imploder;
import com.softicar.platform.dom.attribute.DomAttributeMapComparator;
import com.softicar.platform.dom.attribute.DomAttributeRegistry;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.attribute.IDomAttributeMap;
import com.softicar.platform.dom.attribute.IDomAttributeRegistry;
import com.softicar.platform.dom.document.IDomDocument;
import java.util.HashMap;

public class DomAttributeMap
implements IDomAttributeMap {
    private int hash;
    private final DomAttributeRegistry attributeRegistry;
    private final HashMap<String, IDomAttribute> map = new HashMap();

    @Override
    public IDomDocument getDomDocument() {
        return this.attributeRegistry.getDomDocument();
    }

    @Override
    public IDomAttributeRegistry getAttributeRegistry() {
        return this.attributeRegistry;
    }

    @Override
    public IDomAttribute getAttribute(String name) {
        return this.map.get(name);
    }

    @Override
    public Iterable<IDomAttribute> values() {
        return this.map.values();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return "[" + Imploder.implode(this.values(), (String)", ") + "]";
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other instanceof IDomAttributeMap) {
            return DomAttributeMapComparator.get().isEqual(this, (IDomAttributeMap)other);
        }
        return false;
    }

    DomAttributeMap(DomAttributeRegistry attributeRegistry) {
        this.attributeRegistry = attributeRegistry;
    }

    void add(IDomAttribute newAttribute) {
        IDomAttribute oldAttribute = this.map.put(newAttribute.getName(), newAttribute);
        if (oldAttribute != null) {
            this.hash -= oldAttribute.hashCode();
        }
        this.hash += newAttribute.hashCode();
    }

    void remove(String name) {
        IDomAttribute oldAttribute = this.map.remove(name);
        if (oldAttribute != null) {
            this.hash -= oldAttribute.hashCode();
        }
    }
}

