/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.attribute;

import com.softicar.platform.common.container.iterator.MergeIterator;
import com.softicar.platform.common.container.iterator.SkipIterator;
import com.softicar.platform.dom.attribute.DomAttributeMapComparator;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.attribute.IDomAttributeMap;
import com.softicar.platform.dom.attribute.IDomAttributeRegistry;
import com.softicar.platform.dom.document.IDomDocument;
import java.util.Collections;

public class DomAttributeMapAdapter
implements IDomAttributeMap {
    private int hash;
    private int size;
    private final String name;
    private final IDomAttributeMap map;
    private final IDomAttribute newAttribute;
    private final IDomAttribute oldAttribute;

    @Override
    public IDomDocument getDomDocument() {
        return this.map.getDomDocument();
    }

    @Override
    public IDomAttributeRegistry getAttributeRegistry() {
        return this.map.getAttributeRegistry();
    }

    @Override
    public IDomAttribute getAttribute(String name) {
        return name.equals(this.name) ? this.newAttribute : this.map.getAttribute(name);
    }

    @Override
    public Iterable<IDomAttribute> values() {
        SkipIterator iterable = this.map.values();
        if (this.oldAttribute != null) {
            iterable = new SkipIterator(iterable, (Object)this.oldAttribute);
        }
        if (this.newAttribute != null) {
            iterable = new MergeIterator((Iterable)iterable, Collections.singleton(this.newAttribute));
        }
        return iterable;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other instanceof IDomAttributeMap) {
            return DomAttributeMapComparator.get().isEqual(this, (IDomAttributeMap)other);
        }
        return false;
    }

    static DomAttributeMapAdapter add(IDomAttributeMap map, IDomAttribute newAttribute) {
        return new DomAttributeMapAdapter(map, newAttribute.getName(), newAttribute);
    }

    static DomAttributeMapAdapter remove(IDomAttributeMap map, String attributeName) {
        return new DomAttributeMapAdapter(map, attributeName, null);
    }

    private DomAttributeMapAdapter(IDomAttributeMap map, String name, IDomAttribute newAttribute) {
        this.map = map;
        this.name = name;
        this.newAttribute = newAttribute;
        this.oldAttribute = this.map.getAttribute(name);
        this.hash = this.map.hashCode();
        this.size = this.map.size();
        if (this.oldAttribute != null) {
            this.hash -= this.oldAttribute.hashCode();
            --this.size;
        }
        if (this.newAttribute != null) {
            this.hash += this.newAttribute.hashCode();
            ++this.size;
        }
    }
}

