/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.attribute;

import com.softicar.platform.dom.attribute.DomAttributeMap;
import com.softicar.platform.dom.attribute.DomAttributeMapAdapter;
import com.softicar.platform.dom.attribute.IDomAttribute;
import com.softicar.platform.dom.attribute.IDomAttributeMap;
import com.softicar.platform.dom.attribute.IDomAttributeRegistry;
import com.softicar.platform.dom.document.IDomDocument;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class DomAttributeRegistry
implements IDomAttributeRegistry {
    private final WeakHashMap<IDomAttributeMap, WeakReference<DomAttributeMap>> maps = new WeakHashMap();
    private final IDomDocument document;
    private final DomAttributeMap emptyMap;

    public DomAttributeRegistry(IDomDocument document) {
        this.document = document;
        this.emptyMap = new DomAttributeMap(this);
        this.maps.put(this.emptyMap, new WeakReference<DomAttributeMap>(this.emptyMap));
    }

    @Override
    public IDomDocument getDomDocument() {
        return this.document;
    }

    @Override
    public IDomAttributeMap getEmptyMap() {
        return this.emptyMap;
    }

    @Override
    public IDomAttributeMap put(IDomAttributeMap attributeMap, IDomAttribute newAttribute) {
        DomAttributeMap newMap;
        DomAttributeMapAdapter adapter = DomAttributeMapAdapter.add(attributeMap, newAttribute);
        WeakReference<DomAttributeMap> reference = this.maps.get(adapter);
        DomAttributeMap domAttributeMap = newMap = reference != null ? (DomAttributeMap)reference.get() : null;
        if (newMap == null) {
            newMap = new DomAttributeMap(this);
            for (IDomAttribute attribute : attributeMap.values()) {
                newMap.add(attribute);
            }
            newMap.add(newAttribute);
            this.maps.put(newMap, new WeakReference<DomAttributeMap>(newMap));
        }
        return newMap;
    }

    @Override
    public IDomAttributeMap remove(IDomAttributeMap attributeMap, String attributeName) {
        DomAttributeMap newMap;
        DomAttributeMapAdapter adapter = DomAttributeMapAdapter.remove(attributeMap, attributeName);
        WeakReference<DomAttributeMap> reference = this.maps.get(adapter);
        DomAttributeMap domAttributeMap = newMap = reference != null ? (DomAttributeMap)reference.get() : null;
        if (newMap == null) {
            newMap = new DomAttributeMap(this);
            for (IDomAttribute attribute : attributeMap.values()) {
                newMap.add(attribute);
            }
            newMap.remove(attributeName);
            this.maps.put(newMap, new WeakReference<DomAttributeMap>(newMap));
        }
        return newMap;
    }
}

