/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.document;

import com.softicar.platform.common.container.map.instance.ClassInstanceMap;
import com.softicar.platform.common.container.map.weak.IWeakMap;
import com.softicar.platform.common.container.map.weak.WeakIntHashMap;
import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.attribute.DomAttributeRegistry;
import com.softicar.platform.dom.attribute.IDomAttributeRegistry;
import com.softicar.platform.dom.document.DomBody;
import com.softicar.platform.dom.document.DomHead;
import com.softicar.platform.dom.document.DomNodeIdGenerator;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.document.marker.DomDocumentMarkerHolder;
import com.softicar.platform.dom.document.marker.IDomDocumentMarkerHolder;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.refresh.bus.DomRefreshBus;
import com.softicar.platform.dom.refresh.bus.IDomRefreshBus;
import com.softicar.platform.dom.refresh.bus.IDomRefreshBusListener;
import java.util.Collection;

public abstract class AbstractDomDocument
implements IDomDocument {
    private final DomNodeIdGenerator nodeIdGenerator = new DomNodeIdGenerator();
    private final IDomAttributeRegistry attributeRegistry = new DomAttributeRegistry(this);
    private final IWeakMap<Integer, IDomNode> activeNodes = new WeakIntHashMap(50);
    private final IDomRefreshBus refreshBus = new DomRefreshBus();
    private final ClassInstanceMap<Object> dataMap = new ClassInstanceMap();
    private final IDomDocumentMarkerHolder markerHolder = new DomDocumentMarkerHolder(this);
    private final DomHead head = new DomHead(this);
    private final DomBody body = new DomBody(this);
    private int maximumExistingNodeCount = 0;
    private IDomEvent currentEvent = null;

    public void setMaximumExistingNodeCount(int count) {
        this.maximumExistingNodeCount = count;
    }

    @Override
    public final IDomNode getNode(int nodeId) {
        return (IDomNode)this.activeNodes.get((Comparable)Integer.valueOf(nodeId));
    }

    @Override
    public final IDomNode getNode(String nodeIdString) {
        int nodeId = Integer.parseInt(nodeIdString.substring(1));
        return this.getNode(nodeId);
    }

    @Override
    public final int registerNode(IDomNode node) {
        this.checkForTooManyExistingNodes();
        int nodeId = this.nodeIdGenerator.generateId();
        this.activeNodes.put((Comparable)Integer.valueOf(nodeId), (Object)node);
        if (node instanceof IDomRefreshBusListener) {
            this.refreshBus.addListener((IDomRefreshBusListener)node);
        }
        return nodeId;
    }

    @Override
    public final int getActiveNodeCount() {
        return this.activeNodes.size();
    }

    @Override
    public final void removeCollectedNodes() {
        this.activeNodes.collect();
    }

    @Override
    public void setCurrentEvent(IDomEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    @Override
    public IDomEvent getCurrentEvent() {
        return this.currentEvent;
    }

    @Override
    public void setMarker(IDomNode node, IStaticObject marker) {
        this.markerHolder.setMarker(node, marker);
    }

    @Override
    public boolean hasMarker(IDomNode node, IStaticObject ... markers) {
        return this.markerHolder.hasMarker(node, markers);
    }

    @Override
    public Collection<IDomNode> getNodesWithMarker(IStaticObject marker) {
        return this.markerHolder.getNodesWithMarker(marker);
    }

    @Override
    public Collection<IStaticObject> getMarkers(IDomNode node) {
        return this.markerHolder.getMarkers(node);
    }

    @Override
    public DomHead getHead() {
        return this.head;
    }

    @Override
    public DomBody getBody() {
        return this.body;
    }

    @Override
    public IDomRefreshBus getRefreshBus() {
        return this.refreshBus;
    }

    @Override
    public ClassInstanceMap<Object> getDataMap() {
        return this.dataMap;
    }

    @Override
    public final IDomAttributeRegistry getAttributeRegistry() {
        return this.attributeRegistry;
    }

    private void checkForTooManyExistingNodes() {
        if (this.maximumExistingNodeCount > 0 && this.activeNodes.size() > this.maximumExistingNodeCount) {
            throw new SofticarUserException(DomI18n.MEMORY_CONSUMPTION_IS_TOO_HIGH.concat(" ").concat((IDisplayString)DomI18n.PLEASE_CONTACT_THE_SUPPORT_TEAM));
        }
    }
}

