/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.document.marker;

import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.dom.DomProperties;
import com.softicar.platform.dom.document.DomBody;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.document.marker.IDomDocumentMarkerHolder;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.parent.IDomParentElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;

public class DomDocumentMarkerHolder
implements IDomDocumentMarkerHolder {
    private final IDomDocument document;
    private final Map<IStaticObject, Set<Integer>> markerToNodes;
    private final Map<Integer, Set<IStaticObject>> nodeToMarkers;
    private final boolean testMode;

    public DomDocumentMarkerHolder(IDomDocument document) {
        this.document = document;
        this.markerToNodes = new HashMap<IStaticObject, Set<Integer>>();
        this.nodeToMarkers = new HashMap<Integer, Set<IStaticObject>>();
        this.testMode = (Boolean)DomProperties.TEST_MODE.getValue();
    }

    @Override
    public void setMarker(IDomNode node, IStaticObject marker) {
        if (this.testMode) {
            this.markerToNodes.computeIfAbsent(marker, dummy -> new TreeSet()).add(node.getNodeId());
            this.nodeToMarkers.computeIfAbsent(node.getNodeId(), dummy -> new HashSet()).add(marker);
        }
    }

    @Override
    public Collection<IDomNode> getNodesWithMarker(IStaticObject marker) {
        if (this.testMode) {
            return Optional.ofNullable(this.markerToNodes.get(marker)).map(this::getNodes).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IStaticObject> getMarkers(IDomNode node) {
        if (this.testMode && this.isAppended(node)) {
            return this.nodeToMarkers.getOrDefault(node.getNodeId(), Collections.emptySet());
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasMarker(IDomNode node, IStaticObject ... markers) {
        Collection<IStaticObject> existingMarkers = this.getMarkers(node);
        return Stream.of(markers).allMatch(existingMarkers::contains);
    }

    private Collection<IDomNode> getNodes(Set<Integer> nodeIds) {
        return this.getNodeMap(nodeIds).values();
    }

    private Map<Integer, IDomNode> getNodeMap(Set<Integer> nodeIds) {
        TreeMap<Integer, IDomNode> nodeMap = new TreeMap<Integer, IDomNode>();
        Iterator<Integer> iterator = nodeIds.iterator();
        while (iterator.hasNext()) {
            Integer id = iterator.next();
            IDomNode node = this.document.getNode(id);
            if (node != null && this.isAppended(node)) {
                nodeMap.put(id, node);
                continue;
            }
            iterator.remove();
        }
        return nodeMap;
    }

    private boolean isAppended(IDomNode node) {
        StringBuilder hierarchy = new StringBuilder();
        hierarchy.append(node.getClass().getSimpleName());
        while (true) {
            IDomParentElement parent = node.getParent();
            if (node instanceof DomBody) {
                return true;
            }
            if (parent == null) {
                return false;
            }
            node = parent;
        }
    }
}

