/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.element;

import com.softicar.platform.common.container.collection.MappingCollection;
import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.dom.document.IDomDocument;
import com.softicar.platform.dom.element.DomElementCssClassAttributeManager;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.element.IDomElement;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomAutoEventHandler;
import com.softicar.platform.dom.node.DomNode;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.style.ICssClass;
import com.softicar.platform.dom.style.ICssStyle;
import com.softicar.platform.dom.style.ICssStyleAttribute;
import com.softicar.platform.dom.styles.CssPosition;
import java.io.IOException;
import java.util.Collection;

public abstract class DomElement
extends DomNode
implements IDomElement {
    protected DomElement() {
        this.createElement();
    }

    protected DomElement(boolean doCreate) {
        if (doCreate) {
            this.createElement();
        }
    }

    protected DomElement(IDomDocument document, boolean doCreate) {
        super(document);
        if (doCreate) {
            this.createElement();
        }
    }

    protected void createElement() {
        this.getDomEngine().createElement(this.getNodeId(), this.getTag());
        if (this instanceof IDomAutoEventHandler) {
            for (DomEventType eventType : DomEventType.values()) {
                eventType.enableEventListening(this);
            }
        }
    }

    @Override
    public abstract DomElementTag getTag();

    @Override
    public void setCssClasses(Collection<ICssClass> classes) {
        classes.forEach(ICssClass::beforeUse);
        new DomElementCssClassAttributeManager(this).setClasses((Collection<String>)new MappingCollection(classes, ICssClass::getName));
    }

    @Override
    public void addCssClasses(Collection<ICssClass> classes) {
        classes.forEach(ICssClass::beforeUse);
        new DomElementCssClassAttributeManager(this).addClasses((Collection<String>)new MappingCollection(classes, ICssClass::getName));
    }

    @Override
    public void removeCssClasses(Collection<ICssClass> classes) {
        new DomElementCssClassAttributeManager(this).removeClasses((Collection<String>)new MappingCollection(classes, ICssClass::getName));
    }

    @Override
    public void unsetCssClass() {
        this.setAttribute("class", null);
    }

    @Override
    public DomElement setStyle(ICssStyle style, String value) {
        if (value != null) {
            this.getDomEngine().setNodeStyle(this, style.getJavascriptName(), value);
        } else {
            this.unsetStyle(style);
        }
        return this;
    }

    @Override
    public DomElement setStyle(ICssStyleAttribute styleAttribute) {
        return this.setStyle(styleAttribute.getStyle(), styleAttribute.getValue());
    }

    @Override
    public DomElement unsetStyle(ICssStyle style) {
        this.getDomEngine().unsetNodeStyle(this, style.getJavascriptName());
        return this;
    }

    @Override
    public DomElement setTitle(String title) {
        if (title != null) {
            this.setAttribute("title", title);
        }
        return this;
    }

    @Override
    public void makeDraggable(CssPosition position) {
        this.setStyle(position);
        this.getDomEngine().makeDraggable(this, this);
    }

    @Override
    public void makeDraggable(CssPosition position, IDomNode initNode) {
        this.setStyle(position);
        this.getDomEngine().makeDraggable(this, initNode);
    }

    public <T extends IDomNode> T replaceWith(T replacingNode) {
        if (this.getParent() != null) {
            return this.getParent().replaceChild(replacingNode, this);
        }
        throw new SofticarDeveloperException("Trying to replace a node that has no parent.");
    }

    @Override
    public void buildHtml(Appendable out) throws IOException {
        out.append("<" + this.getTag().getName());
        this.buildAttributesHTML(out);
        out.append("/>");
    }

    public static enum HierarchyType {
        PARENT,
        LEAF;

    }
}

