/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.element;

import com.softicar.platform.dom.element.IDomElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

class DomElementCssClassAttributeManager {
    private final IDomElement element;

    public DomElementCssClassAttributeManager(IDomElement element) {
        this.element = element;
    }

    public void setClasses(Collection<String> classes) {
        this.writeAttribute(classes);
    }

    public void addClasses(Collection<String> classes) {
        this.modifyClasses(it -> it.addAll(classes));
    }

    public void removeClasses(Collection<String> classes) {
        this.modifyClasses(it -> it.removeAll(classes));
    }

    private void modifyClasses(Consumer<Set<String>> modifier) {
        TreeSet<String> classes = new TreeSet<String>(this.readAttribute());
        modifier.accept(classes);
        this.writeAttribute(classes);
    }

    private Collection<String> readAttribute() {
        String attributeValue = this.element.getAttributeValue("class").orElse("").trim();
        if (attributeValue.isEmpty()) {
            return List.of();
        }
        return List.of(attributeValue.split("\\s+"));
    }

    private void writeAttribute(Collection<String> classes) {
        this.element.setAttribute("class", String.join((CharSequence)" ", classes));
    }
}

