/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.element;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.ui.color.IColor;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.style.CssStyle;
import com.softicar.platform.dom.style.ICssClass;
import com.softicar.platform.dom.style.ICssStyle;
import com.softicar.platform.dom.style.ICssStyleAttribute;
import com.softicar.platform.dom.style.ICssStyleValue;
import com.softicar.platform.dom.styles.CssDisplay;
import com.softicar.platform.dom.styles.CssPosition;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface IDomElement
extends IDomNode {
    public DomElementTag getTag();

    default public void setCssClass(ICssClass ... cssClasses) {
        this.setCssClasses(List.of(cssClasses));
    }

    public void setCssClasses(Collection<ICssClass> var1);

    default public void addCssClass(ICssClass ... cssClasses) {
        this.addCssClasses(List.of(cssClasses));
    }

    public void addCssClasses(Collection<ICssClass> var1);

    default public void removeCssClass(ICssClass ... cssClasses) {
        this.removeCssClasses(List.of(cssClasses));
    }

    public void removeCssClasses(Collection<ICssClass> var1);

    public void unsetCssClass();

    public IDomElement setStyle(ICssStyle var1, String var2);

    default public IDomElement setStyle(ICssStyle style, ICssStyleValue value) {
        return this.setStyle(style, value.toString());
    }

    public IDomElement setStyle(ICssStyleAttribute var1);

    public IDomElement unsetStyle(ICssStyle var1);

    default public IDomElement setDisplayNone() {
        return this.setStyle(CssDisplay.NONE);
    }

    default public IDomElement setBackgroundColor(IColor color) {
        return this.setStyle((ICssStyle)CssStyle.BACKGROUND_COLOR, color != null ? color.toHtml() : null);
    }

    default public IDomElement setColor(IColor color) {
        return this.setStyle((ICssStyle)CssStyle.COLOR, color != null ? color.toHtml() : null);
    }

    default public IDomElement setTabIndex(Integer tabIndex) {
        this.setAttribute("tabindex", tabIndex);
        return this;
    }

    public IDomElement setTitle(String var1);

    default public IDomElement setTitle(IDisplayString displayString) {
        return this.setTitle((String)Optional.ofNullable(displayString).map(IDisplayString::toString).orElse(null));
    }

    public void makeDraggable(CssPosition var1);

    public void makeDraggable(CssPosition var1, IDomNode var2);
}

