/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements;

import com.softicar.platform.common.container.comparator.OrderDirection;
import com.softicar.platform.common.container.comparator.ReverseComparator;
import com.softicar.platform.common.container.list.ListFactory;
import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.utils.CastUtils;
import com.softicar.platform.dom.elements.DomValueOption;
import com.softicar.platform.dom.input.DomSelect;
import com.softicar.platform.dom.node.IDomNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.StreamSupport;

public abstract class AbstractDomValueSelect<T>
extends DomSelect<DomValueOption<T>> {
    private final Map<Integer, DomValueOption<T>> valueMap = new TreeMap<Integer, DomValueOption<T>>();
    private DomValueOption<T> nilOption = null;

    public final void addValue(T value) {
        DomValueOption<T> option = new DomValueOption<T>(value, this.getValueDisplayString(value));
        DomValueOption<T> previousOption = this.valueMap.put(this.getValueId(value), option);
        if (previousOption == null) {
            this.appendChild(option);
        } else {
            this.replaceChild(option, previousOption);
        }
    }

    public final void addValues(Iterable<? extends T> values) {
        for (T value : values) {
            this.addValue(value);
        }
    }

    @SafeVarargs
    public final void addValues(T ... values) {
        for (T value : values) {
            this.addValue(value);
        }
    }

    public final void addValuesSortedByDisplayString(Iterable<? extends T> values) {
        this.addValuesSortedByDisplayString(values, OrderDirection.ASCENDING);
    }

    public final void addValuesSortedByDisplayString(Iterable<? extends T> values, OrderDirection direction) {
        DisplayStringComparator comparator = new DisplayStringComparator();
        if (direction == OrderDirection.DESCENDING) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        StreamSupport.stream(values.spliterator(), false).sorted(comparator).forEach(this::addValue);
    }

    public void sortValuesByDisplayString() {
        this.sortValuesByDisplayString(OrderDirection.ASCENDING);
    }

    public void sortValuesByDisplayString(OrderDirection direction) {
        IDisplayString nilValueDisplayString = this.getNilValueDisplayString();
        ArrayList<T> values = new ArrayList<T>(this.getValueList());
        this.removeValues();
        if (nilValueDisplayString != null) {
            this.addNilValue(nilValueDisplayString);
        }
        this.addValuesSortedByDisplayString(values, direction);
    }

    public final T getValue(int index) {
        return ((DomValueOption)this.getOption(index)).getValue();
    }

    public final T getValueById(int id) {
        DomValueOption<T> option = this.valueMap.get(id);
        return option != null ? (T)option.getValue() : null;
    }

    public final List<T> getValueList() {
        ArrayList result = ListFactory.createArrayList((int)this.valueMap.size());
        for (DomValueOption<T> option : this.valueMap.values()) {
            result.add(option.getValue());
        }
        return result;
    }

    public final List<T> getVisualValueList() {
        ArrayList result = ListFactory.createArrayList((int)this.valueMap.size());
        for (IDomNode child : this.getChildren()) {
            DomValueOption option = (DomValueOption)CastUtils.cast((Object)child);
            result.add(option.getValue());
        }
        return result;
    }

    public final boolean containsValue(T value) {
        if (value == null) {
            return this.containsNilOption();
        }
        return this.valueMap.containsKey(this.getValueId(value));
    }

    public final boolean containsNilOption() {
        return this.nilOption != null;
    }

    public final void prependNilValue(IDisplayString displayString) {
        this.nilOption = this.prependChild(new DomValueOption<Object>(null, displayString));
    }

    public final void addNilValue(IDisplayString displayString) {
        this.nilOption = this.appendChild(new DomValueOption<Object>(null, displayString));
    }

    public final IDisplayString getNilValueDisplayString() {
        return Optional.ofNullable(this.nilOption).map(DomValueOption::toDisplay).orElse(null);
    }

    public final DomValueOption<T> getNilOption() {
        return this.nilOption;
    }

    public final void removeValue(T value) {
        if (value != null) {
            this.removeChild(this.valueMap.remove(this.getValueId(value)));
        } else {
            this.removeChild(this.nilOption);
            this.nilOption = null;
        }
    }

    public final void removeValues() {
        this.removeChildren();
        this.valueMap.clear();
        this.nilOption = null;
    }

    public final T getSelectedValue() {
        return Optional.ofNullable((DomValueOption)this.getSelectedOption()).map(DomValueOption::getValue).orElse(null);
    }

    public Collection<T> getSelectedValues() {
        Collection selectedOptions = this.getSelectedOptions();
        ArrayList selectedValues = new ArrayList(selectedOptions.size());
        for (DomValueOption option : selectedOptions) {
            selectedValues.add(option.getValue());
        }
        return selectedValues;
    }

    public void setSelectedValue(T value) {
        if (value != null) {
            this.setSelectedOption(this.valueMap.get(this.getValueId(value)));
        } else {
            this.setSelectedOption(this.nilOption);
        }
    }

    public void setOrAddSelectedValue(T value) {
        if (value != null && !this.containsValue(value)) {
            this.addValue(value);
        }
        this.setSelectedValue(value);
    }

    public void setSelectedValueById(Integer id) {
        if (id != null) {
            try {
                this.setSelectedOption(this.valueMap.get(id));
            }
            catch (SofticarDeveloperException exception) {
                throw new SofticarDeveloperException((Throwable)exception, "Tried to select an invalid option!");
            }
        } else {
            this.setSelectedOption(this.nilOption);
        }
    }

    public final void setSelectedValues(Collection<? extends T> values) {
        ArrayList selectedOptions = ListFactory.createArrayList((int)values.size());
        for (T value : values) {
            if (value != null) {
                selectedOptions.add(this.valueMap.get(this.getValueId(value)));
                continue;
            }
            selectedOptions.add(this.nilOption);
        }
        this.setSelectedOptions(selectedOptions);
    }

    protected abstract Integer getValueId(T var1);

    protected abstract IDisplayString getValueDisplayString(T var1);

    private final class DisplayStringComparator
    implements Comparator<T> {
        private DisplayStringComparator() {
        }

        @Override
        public int compare(T first, T second) {
            int result = AbstractDomValueSelect.this.getValueDisplayString(first).compareToIgnoreCase(AbstractDomValueSelect.this.getValueDisplayString(second));
            return result != 0 ? result : AbstractDomValueSelect.this.getValueId(first) - AbstractDomValueSelect.this.getValueId(second);
        }
    }
}

