/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.input.IDomInputNode;
import com.softicar.platform.dom.node.IDomNode;
import com.softicar.platform.dom.node.tree.DomNodeTree;
import com.softicar.platform.dom.parent.DomParentElement;

public class DomLabel
extends DomParentElement {
    private static final String FOR_ATTRIBUTE_NAME = "for";

    public DomLabel() {
    }

    public DomLabel(IDisplayString labelString) {
        this.appendText(labelString);
    }

    public DomLabel(IDomInputNode inputNode) {
        this.setFor(inputNode);
    }

    public DomLabel setFor(IDomInputNode inputNode) {
        this.setAttribute(FOR_ATTRIBUTE_NAME, inputNode.getNodeIdString());
        return this;
    }

    public DomLabel resetFor() {
        this.unsetAttribute(FOR_ATTRIBUTE_NAME);
        return this;
    }

    public DomLabel updateFor(IDomNode node) {
        new DomNodeTree(node).stream(IDomInputNode.class).findFirst().ifPresentOrElse(this::setFor, this::resetFor);
        return this;
    }

    @Override
    public DomElementTag getTag() {
        return DomElementTag.LABEL;
    }
}

