/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.elements.DomCell;
import com.softicar.platform.dom.elements.DomHeaderCell;
import com.softicar.platform.dom.parent.DomParentElement;

public class DomRow
extends DomParentElement {
    @Override
    public DomElementTag getTag() {
        return DomElementTag.TR;
    }

    public DomCell appendCell() {
        DomCell cell = new DomCell();
        this.appendChild(cell);
        return cell;
    }

    public DomCell appendCell(Object ... children) {
        DomCell cell = this.appendCell();
        cell.appendChildren(children);
        return cell;
    }

    public DomCell appendCell(IDisplayString displayString) {
        return this.appendCell(displayString.toString());
    }

    public <T extends DomCell> T appendCell(T childCell) {
        return this.appendChild(childCell);
    }

    public <T extends DomHeaderCell> T appendCell(T childCell) {
        return this.appendChild(childCell);
    }

    public DomCell appendTextCell(String text) {
        DomCell cell = this.appendCell();
        cell.appendText(text);
        return cell;
    }

    public DomCell appendTextCell(String format, Object ... args) {
        return this.appendCell(String.format(format, args));
    }

    public void appendCells(Object ... children) {
        for (Object child : children) {
            if (child instanceof DomCell || child instanceof DomHeaderCell) {
                this.appendChild(child);
                continue;
            }
            this.appendCell(child);
        }
    }

    public void appendCells(IDisplayString ... displayStrings) {
        for (IDisplayString displayString : displayStrings) {
            this.appendCell(displayString);
        }
    }

    public DomHeaderCell appendHeaderCell() {
        DomHeaderCell cell = new DomHeaderCell();
        this.appendChild(cell);
        return cell;
    }

    public DomHeaderCell appendHeaderCell(Object ... children) {
        DomHeaderCell cell = this.appendHeaderCell();
        cell.appendChildren(children);
        return cell;
    }

    public DomHeaderCell appendHeaderCell(IDisplayString displayString) {
        return this.appendHeaderCell(displayString.toString());
    }

    public <T extends DomHeaderCell> T appendHeaderCell(T childHeaderCell) {
        return this.appendChild(childHeaderCell);
    }

    public void appendHeaderCells(Object ... children) {
        for (Object child : children) {
            this.appendHeaderCell(child);
        }
    }

    public void appendHeaderCells(IDisplayString ... displayStrings) {
        for (IDisplayString displayString : displayStrings) {
            this.appendHeaderCell(displayString);
        }
    }
}

