/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements;

import com.softicar.platform.common.io.mime.IMimeType;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.common.io.resource.IResourceUrl;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.parent.DomParentElement;

public class DomScript
extends DomParentElement {
    private final IResource resource;

    public DomScript() {
        this.resource = null;
    }

    public DomScript(IResource resource) {
        this(resource, false);
    }

    public DomScript(IResource resource, boolean async) {
        this.resource = resource;
        IResourceUrl resourceUrl = this.getDomEngine().getResourceUrl(resource);
        this.setAsync(async);
        this.setType(resource.getMimeType());
        this.setSrc(resourceUrl.toString());
    }

    @Override
    public DomElementTag getTag() {
        return DomElementTag.SCRIPT;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public void setType(IMimeType mimeType) {
        this.setAttribute("type", mimeType.getIdentifier());
    }

    public void setAsync(boolean async) {
        this.setAttribute("async", async);
    }

    public void setDefer(boolean defer) {
        this.setAttribute("defer", defer);
    }
}

