/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.bar;

import com.softicar.platform.common.math.Clamping;
import com.softicar.platform.common.string.formatting.DoubleFormatter;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.style.CssPercent;
import com.softicar.platform.dom.style.CssStyle;
import com.softicar.platform.dom.style.ICssStyle;

public class DomPercentageBar
extends DomDiv {
    private final PercentageDiv percentageDiv;
    private final PercentageLabelDiv percentageLabelDiv;
    private double percentage;

    public DomPercentageBar() {
        this(0.0, true);
    }

    public DomPercentageBar(double percentage) {
        this(percentage, true);
    }

    public DomPercentageBar(double percentage, boolean showPercentage) {
        this.percentage = Clamping.clamp((double)0.0, (double)1.0, (double)percentage);
        this.percentageDiv = new PercentageDiv();
        this.percentageLabelDiv = new PercentageLabelDiv();
        this.setCssClass(DomElementsCssClasses.DOM_PERCENTAGE_BAR);
        this.appendChild(this.percentageDiv);
        if (showPercentage) {
            this.appendChild(this.percentageLabelDiv);
        }
    }

    public void updatePercentage(double percentage) {
        this.percentage = percentage;
        this.percentageDiv.updatePercentage();
        this.percentageLabelDiv.updatePercentage();
    }

    private class PercentageDiv
    extends DomDiv {
        public PercentageDiv() {
            this.setCssClass(DomElementsCssClasses.DOM_PERCENTAGE);
            this.updatePercentage();
        }

        public void updatePercentage() {
            this.setStyle((ICssStyle)CssStyle.WIDTH, new CssPercent(Clamping.clamp((double)0.0, (double)100.0, (double)(DomPercentageBar.this.percentage * 100.0))));
        }
    }

    private class PercentageLabelDiv
    extends DomDiv {
        public PercentageLabelDiv() {
            this.setCssClass(DomElementsCssClasses.DOM_PERCENTAGE_LABEL);
            this.updatePercentage();
        }

        public void updatePercentage() {
            this.removeChildren();
            this.appendText(DoubleFormatter.formatDouble((double)(100.0 * DomPercentageBar.this.percentage), (int)1) + "%");
        }
    }
}

