/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.bar;

import com.softicar.platform.common.math.Clamping;
import com.softicar.platform.common.string.formatting.DoubleFormatter;
import com.softicar.platform.common.ui.color.IColor;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.style.CssPercent;
import com.softicar.platform.dom.style.CssStyle;
import com.softicar.platform.dom.style.ICssStyle;

public class DomPercentageMultiBar
extends DomDiv {
    public DomPercentageMultiBar() {
        this.setCssClass(DomElementsCssClasses.DOM_PERCENTAGE_BAR);
        this.addCssClass(DomElementsCssClasses.DOM_PERCENTAGE_MULTI_BAR);
    }

    public DomPercentageMultiBar addPercentage(double percentage, IColor backgroundColor, IColor textColor) {
        this.appendChild(new PercentageDiv(percentage, backgroundColor, textColor));
        return this;
    }

    private class PercentageDiv
    extends DomDiv {
        private static final double LABEL_THRESHOLD = 0.2;

        public PercentageDiv(double percentage, IColor backgroundColor, IColor textColor) {
            this.setCssClass(DomElementsCssClasses.DOM_PERCENTAGE);
            this.setBackgroundColor(backgroundColor);
            this.setColor(textColor);
            this.setStyle((ICssStyle)CssStyle.WIDTH, new CssPercent(Clamping.clamp((double)0.0, (double)100.0, (double)(percentage * 100.0))));
            String label = DoubleFormatter.formatDouble((double)(100.0 * percentage), (int)1) + "%";
            this.setTitle(label);
            if (percentage > 0.2) {
                this.appendText(label);
            }
        }
    }
}

