/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.button;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.dom.DomCssPseudoClasses;
import com.softicar.platform.dom.element.DomElementTag;
import com.softicar.platform.dom.elements.DomAnchor;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.DomImage;
import com.softicar.platform.dom.elements.anchor.DomHiddenLinkAnchor;
import com.softicar.platform.dom.elements.interfaces.IDomLabeledElement;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomClickEventHandler;
import com.softicar.platform.dom.event.IDomEnterKeyEventHandler;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.event.IDomSpaceKeyEventHandler;
import com.softicar.platform.dom.input.IDomFocusable;
import com.softicar.platform.dom.parent.DomParentElement;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class DomButton
extends DomParentElement
implements IDomFocusable,
IDomLabeledElement<DomButton>,
IDomClickEventHandler,
IDomEnterKeyEventHandler,
IDomSpaceKeyEventHandler {
    private Icon icon = null;
    private Label label = null;
    private DomAnchor linkAnchor = null;
    private INullaryVoidFunction clickCallback = INullaryVoidFunction.NO_OPERATION;
    private Supplier<Optional<IDisplayString>> confirmationMessageSupplier = Optional::empty;
    private boolean enabled = true;

    public DomButton() {
        this.setAttribute("type", "button");
        this.setTabIndex(0);
        this.addCssClass(DomElementsCssClasses.DOM_BUTTON);
        this.getDomEngine().setFireOnKeyUp(this, DomEventType.ENTER, true);
        this.getDomEngine().setFireOnKeyUp(this, DomEventType.SPACE, true);
        this.getDomEngine().setCssClassOnKeyDown(this, DomEventType.ENTER, Collections.singleton(DomCssPseudoClasses.ACTIVE));
        this.getDomEngine().setCssClassOnKeyDown(this, DomEventType.SPACE, Collections.singleton(DomCssPseudoClasses.ACTIVE));
    }

    @Override
    public DomElementTag getTag() {
        return DomElementTag.BUTTON;
    }

    public DomButton setIcon(IResource iconResource) {
        return this.setIcon(iconResource, false);
    }

    public DomButton setPrecoloredIcon(IResource iconResource) {
        return this.setIcon(iconResource, true);
    }

    public DomButton removeIcon() {
        if (this.icon != null) {
            this.removeChild(this.icon);
            this.icon = null;
        }
        return this;
    }

    @Override
    public DomButton setLabel(IDisplayString labelString) {
        this.removeLabel();
        this.label = this.appendChild(new Label(labelString));
        return this;
    }

    public DomButton removeLabel() {
        if (this.label != null) {
            this.removeChild(this.label);
            this.label = null;
        }
        return this;
    }

    @Override
    public DomButton setTitle(IDisplayString titleString) {
        super.setTitle(titleString);
        return this;
    }

    @Override
    public DomButton setMarker(IStaticObject marker) {
        super.setMarker(marker);
        return this;
    }

    public final DomButton setClickCallback(INullaryVoidFunction clickCallback) {
        this.clickCallback = clickCallback;
        return this;
    }

    @Override
    public final void handleClick(IDomEvent event) {
        this.triggerButton();
    }

    @Override
    public final void handleEnterKey(IDomEvent event) {
        this.triggerButton();
    }

    @Override
    public final void handleSpaceKey(IDomEvent event) {
        this.triggerButton();
    }

    public DomButton setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.setTabIndex(0);
                this.listenToEvent(DomEventType.CLICK);
                this.listenToEvent(DomEventType.ENTER);
                this.listenToEvent(DomEventType.SPACE);
                this.removeCssClass(DomCssPseudoClasses.DISABLED);
            } else {
                this.setTabIndex(-1);
                this.unlistenToEvent(DomEventType.CLICK);
                this.unlistenToEvent(DomEventType.ENTER);
                this.unlistenToEvent(DomEventType.SPACE);
                this.addCssClass(DomCssPseudoClasses.DISABLED);
            }
        }
        return this;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final DomButton setConfirmationMessageSupplier(Supplier<IDisplayString> confirmationMessageSupplier) {
        Objects.requireNonNull(confirmationMessageSupplier);
        this.confirmationMessageSupplier = () -> Optional.ofNullable((IDisplayString)confirmationMessageSupplier.get());
        return this;
    }

    public final DomButton setConfirmationMessage(IDisplayString message) {
        return this.setConfirmationMessageSupplier(() -> message);
    }

    public DomButton setExternalLink(String href) {
        this.appendLinkAnchor(href);
        return this;
    }

    private void triggerButton() {
        if (this.enabled) {
            Optional<IDisplayString> confirmationMessage = this.confirmationMessageSupplier.get();
            if (confirmationMessage.isPresent()) {
                this.executeConfirm(() -> ((INullaryVoidFunction)this.clickCallback).apply(), confirmationMessage.get());
            } else {
                this.clickCallback.apply();
            }
        }
    }

    private void appendLinkAnchor(String href) {
        if (this.linkAnchor == null) {
            this.linkAnchor = new DomHiddenLinkAnchor().setOpenInNewTab(true).enableEventDelegation(this);
            this.appendChild(this.linkAnchor);
        }
        this.linkAnchor.setHRef(href);
    }

    private DomButton setIcon(IResource iconResource, boolean precolored) {
        this.removeIcon();
        this.icon = this.prependChild(new Icon(iconResource, precolored));
        return this;
    }

    private class Icon
    extends DomImage {
        public Icon(IResource iconResource, boolean precolored) {
            super(iconResource);
            this.addCssClass(DomElementsCssClasses.DOM_BUTTON_ICON);
            if (precolored) {
                this.addCssClass(DomCssPseudoClasses.PRECOLORED);
            }
        }
    }

    private class Label
    extends DomDiv {
        public Label(IDisplayString labelString) {
            this.addCssClass(DomElementsCssClasses.DOM_BUTTON_LABEL);
            this.appendText(labelString);
        }
    }
}

