/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.button.option;

import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.Consumers;
import com.softicar.platform.common.core.interfaces.IStaticObject;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.dom.DomCssPseudoClasses;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.bar.DomActionBar;
import com.softicar.platform.dom.elements.button.DomButton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class DomButtonOptionList<T>
extends DomActionBar {
    private final Map<T, DomButton> optionButtonMap = new HashMap<T, DomButton>();
    private boolean nullable = false;
    private Consumer<T> selectCallback = Consumers.noOperation();
    private Optional<T> selectedOption = Optional.empty();
    private Optional<DomButton> selectedButton = Optional.empty();

    public DomButtonOptionList<T> setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public DomButtonOptionList<T> addOption(T option, IResource icon, IDisplayString label) {
        DomButton button = new DomButton().setClickCallback(() -> this.handleClick(option)).setIcon(icon).setLabel(label);
        this.appendChild(button);
        this.optionButtonMap.put(option, button);
        return this;
    }

    public DomButtonOptionList<T> setOptionMarker(T option, IStaticObject marker) {
        this.optionButtonMap.get(option).setMarker(marker);
        return this;
    }

    public DomButtonOptionList<T> setSelectCallback(Consumer<T> selectCallback) {
        this.selectCallback = selectCallback;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DomButtonOptionList<T> setSelectedOption(T option) {
        this.selectedButton.ifPresent(button -> DomButtonOptionList.unmarkAsSelected(button));
        if (option != null) {
            DomButton optionButton = this.optionButtonMap.get(option);
            if (optionButton == null) throw new SofticarUserException((IDisplayString)DomI18n.TRIED_TO_SELECT_AN_OPTION_THAT_WAS_NOT_CONTAINED_IN_THE_LIST_OF_AVAILABLE_OPTIONS);
            DomButtonOptionList.markAsSelected(optionButton);
            this.selectedOption = Optional.of(option);
            this.selectedButton = Optional.of(optionButton);
            return this;
        } else {
            this.selectedOption = Optional.empty();
            this.selectedButton = Optional.empty();
        }
        return this;
    }

    public Optional<T> getSelectedOption() {
        return this.selectedOption;
    }

    public static void markAsSelected(DomButton button) {
        button.addCssClass(DomCssPseudoClasses.SELECTED);
    }

    public static void unmarkAsSelected(DomButton button) {
        button.removeCssClass(DomCssPseudoClasses.SELECTED);
    }

    private void handleClick(T option) {
        if (this.nullable && this.getSelectedOption().equals(Optional.ofNullable(option))) {
            this.setSelectedOption(null);
        } else {
            this.setSelectedOption(option);
        }
        this.selectCallback.accept(option);
    }
}

