/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.button.popup.help;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.message.DomMessageDiv;
import com.softicar.platform.dom.elements.message.style.DomMessageType;
import com.softicar.platform.dom.elements.popup.DomPopup;
import com.softicar.platform.dom.node.DomNode;

public class DomHelpPopupButton
extends DomButton {
    private final IDisplayString popupCaption;
    private final IDisplayString popupSubCaption;
    private IDisplayString popupHelpText = null;
    private DomNode popupHelpTextNode = null;
    private DomPopup popup = null;

    public DomHelpPopupButton(IDisplayString popupCaption, IDisplayString popupSubCaption, IDisplayString popupHelpText) {
        this(popupCaption, popupSubCaption);
        this.popupHelpText = popupHelpText;
    }

    public DomHelpPopupButton(IDisplayString popupCaption, IDisplayString popupSubCaption, DomNode popupHelpTextNode) {
        this(popupCaption, popupSubCaption);
        this.popupHelpTextNode = popupHelpTextNode;
    }

    private DomHelpPopupButton(IDisplayString popupCaption, IDisplayString popupSubCaption) {
        this.popupCaption = popupCaption;
        this.popupSubCaption = popupSubCaption;
        this.setIcon(DomElementsImages.HELP.getResource());
        this.setTitle((IDisplayString)DomI18n.DISPLAY_HELP);
        this.setClickCallback(this::handleClick);
    }

    private void handleClick() {
        this.getPopup().show();
    }

    private DomPopup getPopup() {
        if (this.popup == null) {
            this.popup = new HelpPopup();
        }
        return this.popup;
    }

    private class HelpPopup
    extends DomPopup {
        public HelpPopup() {
            this.setCaption(DomHelpPopupButton.this.popupCaption);
            this.setSubCaption(DomHelpPopupButton.this.popupSubCaption);
            this.removeChildren();
            if (DomHelpPopupButton.this.popupHelpText != null) {
                this.appendChild(new DomMessageDiv(DomMessageType.INFO, DomHelpPopupButton.this.popupHelpText));
            } else {
                this.appendChild(DomHelpPopupButton.this.popupHelpTextNode);
            }
            this.appendCloseButton();
        }
    }
}

