/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.checkbox;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.Consumers;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.dom.DomCssPseudoClasses;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomClickEventHandler;
import com.softicar.platform.dom.event.IDomEnterKeyEventHandler;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.event.IDomSpaceKeyEventHandler;
import java.util.Collections;
import java.util.function.Consumer;

public class DomCheckbox
extends DomDiv
implements IDomClickEventHandler,
IDomEnterKeyEventHandler,
IDomSpaceKeyEventHandler {
    private boolean enabled = false;
    private boolean checked = false;
    private Consumer<Boolean> changeCallback = Consumers.noOperation();
    private final DomCheckboxBox checkboxBox = this.appendChild(new DomCheckboxBox());
    private final DomCheckboxLabel checkboxLabel = new DomCheckboxLabel();

    public DomCheckbox() {
        this.setEnabled(true);
        this.setCssClass(DomElementsCssClasses.DOM_CHECKBOX);
        this.getDomEngine().setFireOnKeyUp(this, DomEventType.ENTER, true);
        this.getDomEngine().setFireOnKeyUp(this, DomEventType.SPACE, true);
        this.getDomEngine().setCssClassOnKeyDown(this, DomEventType.ENTER, Collections.singleton(DomCssPseudoClasses.ACTIVE));
        this.getDomEngine().setCssClassOnKeyDown(this, DomEventType.SPACE, Collections.singleton(DomCssPseudoClasses.ACTIVE));
    }

    @Override
    public void handleClick(IDomEvent event) {
        this.handleEvent();
    }

    @Override
    public void handleEnterKey(IDomEvent event) {
        this.handleEvent();
    }

    @Override
    public void handleSpaceKey(IDomEvent event) {
        this.handleEvent();
    }

    public DomCheckbox setLabel(IDisplayString label) {
        this.checkboxLabel.setLabel(label);
        this.appendChild(this.checkboxLabel);
        return this;
    }

    @Override
    public DomCheckbox setTitle(IDisplayString title) {
        super.setTitle(title);
        return this;
    }

    public DomCheckbox setChangeCallback(INullaryVoidFunction changeCallback) {
        return this.setChangeCallback((Boolean dummy) -> changeCallback.apply());
    }

    public DomCheckbox setChangeCallback(Consumer<Boolean> changeCallback) {
        if (!this.hasCustomChangeCallback()) {
            this.changeCallback = changeCallback;
            return this;
        }
        throw new SofticarDeveloperException("Tried to overwrite the change callback.");
    }

    public boolean hasCustomChangeCallback() {
        return !Consumers.isNoOperation(this.changeCallback);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DomCheckbox setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.setTabIndex(0);
                this.listenToEvent(DomEventType.CLICK);
                this.listenToEvent(DomEventType.ENTER);
                this.listenToEvent(DomEventType.SPACE);
                this.removeCssClass(DomCssPseudoClasses.DISABLED);
            } else {
                this.setTabIndex(-1);
                this.unlistenToEvent(DomEventType.CLICK);
                this.unlistenToEvent(DomEventType.ENTER);
                this.unlistenToEvent(DomEventType.SPACE);
                this.addCssClass(DomCssPseudoClasses.DISABLED);
            }
        }
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public DomCheckbox setChecked(boolean checked) {
        this.setCheckedState(checked);
        this.executeCallback();
        return this;
    }

    private void setCheckedState(boolean checked) {
        if (checked != this.checked) {
            this.checkboxBox.setChecked(checked);
            this.checked = checked;
        }
    }

    private void handleEvent() {
        if (this.enabled) {
            this.setCheckedState(!this.checked);
            this.executeCallback();
        }
    }

    private void executeCallback() {
        this.changeCallback.accept(this.checked);
    }

    private class DomCheckboxBox
    extends DomDiv {
        private final DomCheckboxBoxFiller filler = new DomCheckboxBoxFiller();

        public DomCheckboxBox() {
            this.setCssClass(DomElementsCssClasses.DOM_CHECKBOX_BOX);
        }

        public void setChecked(boolean checked) {
            this.removeChildren();
            if (checked) {
                this.appendChild(this.filler);
            }
        }

        private class DomCheckboxBoxFiller
        extends DomDiv {
            public DomCheckboxBoxFiller() {
                this.setCssClass(DomElementsCssClasses.DOM_CHECKBOX_BOX_FILLER);
            }
        }
    }

    private class DomCheckboxLabel
    extends DomDiv {
        public DomCheckboxLabel() {
            this.setCssClass(DomElementsCssClasses.DOM_CHECKBOX_LABEL);
        }

        public void setLabel(IDisplayString label) {
            this.removeChildren();
            if (label != null) {
                this.appendText(label.toString());
            }
        }
    }
}

