/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.dialog;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.dialog.DomModalConfirmMarker;
import com.softicar.platform.dom.elements.dialog.DomModalDialogPopup;
import java.util.Objects;

public class DomModalConfirmPopup
extends DomModalDialogPopup {
    private final OkayButton okayButton;

    public DomModalConfirmPopup(INullaryVoidFunction confirmHandler, IDisplayString message) {
        Objects.requireNonNull(confirmHandler);
        Objects.requireNonNull(message);
        this.getContent().appendText(message);
        this.okayButton = new OkayButton(confirmHandler);
        this.appendActionNode(this.okayButton);
        this.appendCancelButton().setMarker(DomModalConfirmMarker.CANCEL_BUTTON);
    }

    @Override
    public void show() {
        super.show();
        this.getDomEngine().focus(this.okayButton);
    }

    private class OkayButton
    extends DomButton {
        private final INullaryVoidFunction confirmHandler;

        public OkayButton(INullaryVoidFunction confirmHandler) {
            this.confirmHandler = confirmHandler;
            this.setLabel((IDisplayString)DomI18n.OK);
            this.setIcon(DomElementsImages.DIALOG_OKAY.getResource());
            this.setClickCallback(this::handleClick);
            this.setMarker(DomModalConfirmMarker.OKAY_BUTTON);
        }

        private void handleClick() {
            DomModalConfirmPopup.this.getCloseManager().closePopupNonInteractive();
            this.confirmHandler.apply();
        }
    }
}

