/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.dialog;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.DomElementsImages;
import com.softicar.platform.dom.elements.button.DomButton;
import com.softicar.platform.dom.elements.dialog.DomModalDialogPopup;
import com.softicar.platform.dom.elements.dialog.DomModalPromptMarker;
import com.softicar.platform.dom.event.IDomEnterKeyEventHandler;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.input.DomTextInput;
import java.util.Objects;
import java.util.function.Consumer;

public class DomModalPromptPopup
extends DomModalDialogPopup {
    private final InputElement inputElement;
    private final Consumer<String> promptHandler;

    public DomModalPromptPopup(Consumer<String> promptHandler, IDisplayString message, String defaultValue) {
        this.promptHandler = Objects.requireNonNull(promptHandler);
        Objects.requireNonNull(message);
        this.inputElement = new InputElement(defaultValue);
        this.getContent().appendText(message);
        this.getContent().appendChild(this.inputElement);
        this.appendActionNode(new OkayButton());
        this.appendCancelButton().setMarker(DomModalPromptMarker.CANCEL_BUTTON);
    }

    @Override
    public void show() {
        super.show();
        this.getDomEngine().focus(this.inputElement);
    }

    private void closeAndApplyInput() {
        this.getCloseManager().closePopupNonInteractive();
        this.promptHandler.accept((String)this.inputElement.getValue());
    }

    private class InputElement
    extends DomTextInput
    implements IDomEnterKeyEventHandler {
        public InputElement(String defaultValue) {
            this.setValue(defaultValue);
            this.select();
            this.setMarker(DomModalPromptMarker.INPUT_ELEMENT);
        }

        @Override
        public void handleEnterKey(IDomEvent event) {
            DomModalPromptPopup.this.closeAndApplyInput();
        }
    }

    private class OkayButton
    extends DomButton {
        public OkayButton() {
            this.setLabel((IDisplayString)DomI18n.OK);
            this.setIcon(DomElementsImages.DIALOG_OKAY.getResource());
            this.setClickCallback(() -> DomModalPromptPopup.this.closeAndApplyInput());
            this.setMarker(DomModalPromptMarker.OKAY_BUTTON);
        }
    }
}

