/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.image.free.text;

import com.softicar.platform.common.core.exceptions.SofticarIOException;
import com.softicar.platform.common.io.mime.IMimeType;
import com.softicar.platform.common.io.mime.MimeType;
import com.softicar.platform.common.io.resource.IResource;
import com.softicar.platform.common.io.resource.hash.ResourceHash;
import com.softicar.platform.dom.elements.image.free.text.IDomFreeTextImageConfiguration;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.imageio.ImageIO;

public class DomFreeTextImageResource
implements IResource {
    private final IDomFreeTextImageConfiguration configuration;

    public DomFreeTextImageResource(IDomFreeTextImageConfiguration configuration) {
        this.configuration = configuration;
    }

    public InputStream getResourceAsStream() {
        int height;
        int width;
        int y;
        int x;
        Font font = new Font(this.configuration.getFontFamily(), this.configuration.getAwtFontStyle(), this.configuration.getFontSize());
        Rectangle bounds = DomFreeTextImageResource.getTextBounds(this.configuration.getText(), font);
        AffineTransform transformation = new AffineTransform();
        if (this.configuration.isRotate()) {
            x = -bounds.y;
            y = bounds.width + bounds.x;
            width = bounds.height;
            height = bounds.width;
            transformation.setToRotation(-1.5707963267948966, x, y);
        } else {
            x = -bounds.x;
            y = -bounds.y;
            width = bounds.width;
            height = bounds.height;
            transformation.setToIdentity();
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        try {
            graphics.setColor(new Color(0, true));
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            graphics.setFont(font);
            int fontAlpha = this.configuration.getFontAlpha();
            int rgbValue = this.configuration.getFontColor().getRgbValue();
            graphics.setColor(fontAlpha == 255 ? new Color(rgbValue) : new Color((fontAlpha << 24) + rgbValue, true));
            graphics.setTransform(transformation);
            if (this.configuration.isAntiAliasing()) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            graphics.drawString(this.configuration.getText(), x, y);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", output);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException exception) {
            throw new SofticarIOException(exception);
        }
        finally {
            graphics.dispose();
        }
    }

    private static Rectangle getTextBounds(String text, Font font) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D graphics = image.createGraphics();
        FontRenderContext renderContext = graphics.getFontRenderContext();
        TextLayout layout = new TextLayout(text, font, renderContext);
        return layout.getPixelBounds(renderContext, 0.0f, 0.0f);
    }

    public IMimeType getMimeType() {
        return MimeType.IMAGE_PNG;
    }

    public Optional<Charset> getCharset() {
        return Optional.empty();
    }

    public Optional<String> getFilename() {
        return Optional.empty();
    }

    public Optional<ResourceHash> getContentHash() {
        return Optional.empty();
    }
}

