/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.number.parser.DoubleParser;
import com.softicar.platform.common.string.formatting.DoubleFormatter;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.input.AbstractDomNumberInput;

public class DomDoubleInput
extends AbstractDomNumberInput {
    private int displayPrecision = 6;
    private int allowedPrecision = 0;
    private Double begin = null;
    private Double end = null;

    public DomDoubleInput() {
    }

    public DomDoubleInput(double value) {
        super("" + value);
    }

    public Double getDouble() {
        this.trimValue();
        this.fixComma();
        if (this.getValue() == null) {
            return null;
        }
        Object text = this.getValue();
        try {
            if (((String)text).equals("")) {
                return 0.0;
            }
            Double result = Double.valueOf(text);
            if (this.begin != null && this.begin > result) {
                this.throwOutOfRange((String)text);
            }
            if (this.end != null && this.end < result) {
                this.throwOutOfRange((String)text);
            }
            if (this.allowedPrecision != 0 && ((String)text).matches(".+\\..{" + (this.allowedPrecision + 1) + ",}")) {
                throw new TooPreciseDoubleException((String)text, this.allowedPrecision);
            }
            return result;
        }
        catch (NumberFormatException exception) {
            throw new SofticarUserException((Throwable)exception, DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_A_VALID_DECIMAL_NUMBER.toDisplay(text));
        }
    }

    public Double getDoubleOrNull() {
        this.trimValue();
        this.fixComma();
        if (this.getValue() != null) {
            if (DoubleParser.isDouble(this.getValue())) {
                return Double.valueOf(this.getValue());
            }
            return null;
        }
        return null;
    }

    public void setDouble(Double value) {
        if (value != null) {
            this.setValue(DoubleFormatter.formatDouble((double)value, (int)this.displayPrecision));
        } else {
            this.setValue(null);
        }
    }

    public void fixComma() {
        if (this.getValue() != null) {
            this.setValue(((String)this.getValue()).replace(",", "."));
        }
    }

    public void setRange(Double begin, Double end) {
        this.begin = begin;
        this.end = end;
    }

    public void setMinimumDouble(Double minimum) {
        this.begin = minimum;
    }

    public void setMaximumDouble(Double maximum) {
        this.end = maximum;
    }

    public void setAllowedPrecision(int precision) {
        if (precision < 0) {
            throw new SofticarDeveloperException("Decimal precision must be an non-negative integer");
        }
        this.allowedPrecision = precision;
    }

    public int getAllowedPrecision() {
        return this.allowedPrecision;
    }

    public void setDisplayPrecision(int precision) {
        this.displayPrecision = precision;
    }

    private void throwOutOfRange(String value) {
        throw new SofticarUserException(DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_IN_THE_RANGE_BETWEEN_ARG2_AND_ARG3.toDisplay((Object)value, this.begin == null ? "-" + DomI18n.INFINITY : this.begin.toString(), this.end == null ? DomI18n.INFINITY : this.end.toString()));
    }

    public static class TooPreciseDoubleException
    extends SofticarUserException {
        private static final long serialVersionUID = 1L;

        public TooPreciseDoubleException(String valueAsText, int allowedPrecision) {
            super(DomI18n.THE_DECIMAL_VALUE_ARG1_MUST_HAVE_ARG2_OR_LESS_DECIMAL_PLACES.toDisplay((Object)valueAsText, (Object)allowedPrecision));
        }
    }
}

