/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.number.parser.FloatParser;
import com.softicar.platform.common.string.formatting.DoubleFormatter;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.input.DomTextInput;

public class DomFloatInput
extends DomTextInput {
    private int displayPrecision = 4;
    private int allowedPrecision = 0;
    private Float begin = null;
    private Float end = null;

    public DomFloatInput() {
    }

    public DomFloatInput(float value) {
        super("" + value);
    }

    public Float getFloat() {
        this.trimValue();
        this.fixComma();
        if (this.getValue() == null) {
            return null;
        }
        Object text = this.getValue();
        try {
            if (((String)text).equals("")) {
                return Float.valueOf(0.0f);
            }
            Float result = Float.valueOf(text);
            if (this.begin != null && this.begin.floatValue() > result.floatValue()) {
                this.throwOutOfRange((String)text);
            }
            if (this.end != null && this.end.floatValue() < result.floatValue()) {
                this.throwOutOfRange((String)text);
            }
            if (this.allowedPrecision != 0 && ((String)text).matches(".+\\..{" + (this.allowedPrecision + 1) + ",}")) {
                throw new TooPreciseFloatException((String)text, this.allowedPrecision);
            }
            return result;
        }
        catch (NumberFormatException exception) {
            throw new SofticarUserException((Throwable)exception, DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_A_VALID_DECIMAL_NUMBER.toDisplay(text));
        }
    }

    public Float getFloatOrNull() {
        this.trimValue();
        this.fixComma();
        if (this.getValue() != null) {
            if (FloatParser.isFloat(this.getValue())) {
                return Float.valueOf(this.getValue());
            }
            return null;
        }
        return null;
    }

    public void setFloat(Float value) {
        if (value != null) {
            this.setValue(DoubleFormatter.formatDouble((double)value.doubleValue(), (int)this.displayPrecision));
        } else {
            this.setValue(null);
        }
    }

    public void fixComma() {
        if (this.getValue() != null) {
            this.setValue(((String)this.getValue()).replace(",", "."));
        }
    }

    public void setRange(Float begin, Float end) {
        this.begin = begin;
        this.end = end;
    }

    public void setMinimumDouble(Float minimum) {
        this.begin = minimum;
    }

    public void setMaximumDouble(Float maximum) {
        this.end = maximum;
    }

    public void setAllowedPrecision(int precision) {
        if (precision < 0) {
            throw new SofticarDeveloperException("Decimal precision must be an non-negative integer");
        }
        this.allowedPrecision = precision;
    }

    public int getAllowedPrecision() {
        return this.allowedPrecision;
    }

    public void setDisplayPrecision(int precision) {
        this.displayPrecision = precision;
    }

    private void throwOutOfRange(String value) {
        throw new SofticarUserException(DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_IN_THE_RANGE_BETWEEN_ARG2_AND_ARG3.toDisplay((Object)value, this.begin == null ? "-" + DomI18n.INFINITY : this.begin.toString(), this.end == null ? DomI18n.INFINITY : this.end.toString()));
    }

    public static class TooPreciseFloatException
    extends SofticarUserException {
        private static final long serialVersionUID = 1L;

        public TooPreciseFloatException(String valueAsText, int allowedPrecision) {
            super(DomI18n.THE_DECIMAL_VALUE_ARG1_MUST_HAVE_ARG2_OR_LESS_DECIMAL_PLACES.toDisplay((Object)valueAsText, (Object)allowedPrecision));
        }
    }
}

