/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input;

import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.input.AbstractDomNumberInput;

public class DomIntegerInput
extends AbstractDomNumberInput {
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;

    public DomIntegerInput() {
    }

    public DomIntegerInput(int value) {
        super("" + value);
    }

    public DomIntegerInput(Integer value) {
        if (value != null) {
            this.setValue("" + value);
        }
    }

    public Integer getInteger() {
        Integer integer = this.getIntegerOrNull();
        return integer != null ? integer : 0;
    }

    public Integer getIntegerOrNull() {
        if (this.getValue() == null) {
            return null;
        }
        String text = ((String)this.getValue()).trim();
        try {
            if (text.isEmpty()) {
                return null;
            }
            Integer result = Integer.valueOf(text);
            if (result < this.minimum) {
                this.throwOutOfRange(text);
            }
            if (result > this.maximum) {
                this.throwOutOfRange(text);
            }
            return result;
        }
        catch (NumberFormatException exception) {
            throw new SofticarUserException((Throwable)exception, DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_IN_THE_RANGE_BETWEEN_ARG2_AND_ARG3.toDisplay((Object)text, (Object)this.minimum, (Object)this.maximum));
        }
    }

    public void setInteger(Integer value) {
        if (value != null) {
            this.setValue("" + value);
        } else {
            this.setValue(null);
        }
    }

    public void setRange(Integer begin, Integer end) {
        this.minimum = begin;
        this.maximum = end;
    }

    public void setMinimumInteger(Integer minimum) {
        this.minimum = minimum;
    }

    public void setMaximumInteger(Integer maximum) {
        this.maximum = maximum;
    }

    private void throwOutOfRange(String value) {
        throw new SofticarUserException(DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_IN_THE_RANGE_BETWEEN_ARG2_AND_ARG3.toDisplay((Object)value, (Object)this.minimum, (Object)this.maximum));
    }
}

