/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input;

import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.input.AbstractDomNumberInput;

public class DomLongInput
extends AbstractDomNumberInput {
    private long minimum = Long.MIN_VALUE;
    private long maximum = Long.MAX_VALUE;

    public DomLongInput() {
    }

    public DomLongInput(int value) {
        super("" + value);
    }

    public DomLongInput(long value) {
        super("" + value);
    }

    public Long getLong() {
        String text = ((String)this.getValue()).trim();
        try {
            if (text.equals("")) {
                return 0L;
            }
            Long result = Long.valueOf(text);
            if (result < this.minimum) {
                this.throwOutOfRange(text);
            }
            if (result > this.maximum) {
                this.throwOutOfRange(text);
            }
            return result;
        }
        catch (NumberFormatException exception) {
            throw new SofticarUserException((Throwable)exception, DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_IN_THE_RANGE_BETWEEN_ARG2_AND_ARG3.toDisplay((Object)text, (Object)this.minimum, (Object)this.maximum));
        }
    }

    public Long getLongOrNull() {
        if (((String)this.getValue()).trim().isEmpty()) {
            return null;
        }
        return this.getLong();
    }

    public void setLong(Long value) {
        this.setValue("" + value);
    }

    public void setRange(Long begin, Long end) {
        this.minimum = begin;
        this.maximum = end;
    }

    public void setMinimumLong(Long minimum) {
        this.minimum = minimum;
    }

    public void setMaximumLong(Long maximum) {
        this.maximum = maximum;
    }

    private void throwOutOfRange(String value) {
        throw new SofticarUserException(DomI18n.THE_SPECIFIED_VALUE_ARG1_IS_NOT_IN_THE_RANGE_BETWEEN_ARG2_AND_ARG3.toDisplay((Object)value, (Object)this.minimum, (Object)this.maximum));
    }
}

