/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input.auto;

import com.softicar.platform.common.core.logging.Log;
import com.softicar.platform.common.string.formatting.StackTraceFormatting;
import com.softicar.platform.dom.elements.input.auto.IDomAutoCompletePreferenceInputEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public abstract class AbstractDomAutoCompletePreferenceInputEngine<T>
implements IDomAutoCompletePreferenceInputEngine<T> {
    @Override
    public Collection<T> findMatches(String pattern, int limit) {
        return this.findPerfectMatchSafe(pattern).map(it -> Collections.singleton(it)).orElse(new ItemFetcher(pattern, limit).fetch());
    }

    private Optional<T> findPerfectMatchSafe(String pattern) {
        try {
            return this.findPerfectMatch(pattern);
        }
        catch (Exception exception) {
            this.logException(exception);
            return Optional.empty();
        }
    }

    private Collection<T> findMatchingItemsSafe(String pattern, int fetchOffset, int fetchSize) {
        try {
            return Optional.ofNullable(this.findMatchingItems(pattern, fetchOffset, fetchSize)).orElse(Collections.emptyList());
        }
        catch (Exception exception) {
            this.logException(exception);
            return Collections.emptyList();
        }
    }

    private Collection<T> filterMatchingItemsSafe(String pattern, Collection<T> matchingItems) {
        try {
            return this.filterMatchingItems(pattern, matchingItems);
        }
        catch (Exception exception) {
            this.logException(exception);
            return Collections.emptyList();
        }
    }

    private void logException(Exception exception) {
        Log.ferror((String)StackTraceFormatting.getStackTraceAsString((Throwable)exception));
    }

    private class ItemFetcher {
        private final String pattern;
        private final int limit;
        private final Collection<T> items;

        public ItemFetcher(String pattern, int limit) {
            this.pattern = pattern;
            this.limit = limit;
            this.items = new ArrayList();
        }

        public Collection<T> fetch() {
            boolean done;
            this.items.clear();
            int fetchOffset = 0;
            int fetchSize = this.limit;
            while (this.items.size() < this.limit && !(done = this.fetchSome(fetchOffset, fetchSize))) {
                fetchOffset += fetchSize;
                fetchSize *= 2;
            }
            return this.items;
        }

        private boolean fetchSome(int fetchOffset, int fetchSize) {
            Collection matchingItems = AbstractDomAutoCompletePreferenceInputEngine.this.findMatchingItemsSafe(this.pattern, fetchOffset, fetchSize);
            Collection filtered = AbstractDomAutoCompletePreferenceInputEngine.this.filterMatchingItemsSafe(this.pattern, matchingItems);
            for (Object entity : filtered) {
                if (this.items.size() < this.limit) {
                    this.items.add(entity);
                    continue;
                }
                return true;
            }
            return matchingItems.size() < fetchSize;
        }
    }
}

