/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input.auto;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.interfaces.INullaryVoidFunction;
import com.softicar.platform.dom.element.IDomElement;
import com.softicar.platform.dom.elements.DomDiv;
import com.softicar.platform.dom.elements.DomElementsCssClasses;
import com.softicar.platform.dom.elements.input.auto.DomAutoCompleteInputConfiguration;
import com.softicar.platform.dom.elements.input.auto.DomAutoCompleteInputFilterDisplay;
import com.softicar.platform.dom.elements.input.auto.DomAutoCompleteInputSelection;
import com.softicar.platform.dom.elements.input.auto.DomAutoCompleteListGenerator;
import com.softicar.platform.dom.elements.input.auto.IDomAutoCompleteInputEngine;
import com.softicar.platform.dom.event.DomEventType;
import com.softicar.platform.dom.event.IDomEvent;
import com.softicar.platform.dom.event.IDomEventHandler;
import com.softicar.platform.dom.input.DomTextInput;
import com.softicar.platform.dom.input.IDomStringInputNode;
import com.softicar.platform.dom.input.IDomValueBasedInputNode;
import com.softicar.platform.dom.input.auto.DomAutoCompleteInputValidationMode;
import com.softicar.platform.dom.input.auto.DomAutoCompleteList;
import com.softicar.platform.dom.input.auto.IDomAutoCompleteInput;
import com.softicar.platform.dom.input.auto.IDomAutoCompleteInputConfiguration;
import com.softicar.platform.dom.input.auto.IDomAutoCompleteInputSelection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DomAutoCompleteInput<T>
extends DomDiv
implements IDomAutoCompleteInput<T>,
IDomValueBasedInputNode<T> {
    private IDomAutoCompleteInputEngine<T> inputEngine;
    private final boolean sloppyAmbiguityCheck;
    private final DomAutoCompleteInputFilterDisplay filterDisplay;
    private final InputField inputField;
    private INullaryVoidFunction changeCallback;
    private final IDomAutoCompleteInputConfiguration configuration;

    public DomAutoCompleteInput(IDomAutoCompleteInputEngine<T> inputEngine, boolean sloppyAmbiguityCheck, DomAutoCompleteInputValidationMode defaultMode) {
        this.inputEngine = inputEngine;
        this.sloppyAmbiguityCheck = sloppyAmbiguityCheck;
        this.filterDisplay = new DomAutoCompleteInputFilterDisplay();
        this.inputField = new InputField();
        this.changeCallback = null;
        this.configuration = new DomAutoCompleteInputConfiguration(this, this.inputField);
        this.setCssClass(DomElementsCssClasses.DOM_AUTO_COMPLETE_INPUT);
        this.appendChild(this.inputField);
        this.appendChild(this.filterDisplay);
        this.refreshFilters();
        this.initializeAutoComplete(defaultMode);
    }

    public void refreshFilters() {
        this.inputEngine.refresh();
        this.filterDisplay.refresh(this.inputEngine);
        this.refreshInputValidity();
    }

    public void setChangeCallback(INullaryVoidFunction changeCallback) {
        if (changeCallback != null) {
            this.changeCallback = new CompositeCallback(this::refreshInputValidity, changeCallback)::apply;
            this.inputField.listenToEvent(DomEventType.CHANGE);
        } else {
            this.changeCallback = null;
            this.inputField.unlistenToEvent(DomEventType.CHANGE);
        }
    }

    @Override
    public IDomAutoCompleteInputConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public IDomStringInputNode getInputField() {
        return this.inputField;
    }

    @Override
    public DomAutoCompleteList getItemList(String pattern) {
        return new DomAutoCompleteListGenerator<T>(this.inputEngine, 10).generate(this.getTrimmedLowerCase(pattern));
    }

    @Override
    public IDomAutoCompleteInputSelection<T> getSelection() {
        return new DomAutoCompleteInputSelection<T>(this.inputEngine, this.configuration, this::getMatchingItems, this.getTrimmed((String)this.inputField.getValue()));
    }

    @Override
    public T getValue() {
        return this.getSelection().getValueOrNull();
    }

    @Override
    public void setValue(T value) {
        String valueString = Optional.ofNullable(value).map(this.inputEngine::getDisplayString).map(IDisplayString::toString).orElse("");
        this.inputField.setValue(valueString);
    }

    @Override
    public void setValueAndValidate(T value) {
        this.setValue(value);
        this.refreshInputValidity();
    }

    @Override
    public DomAutoCompleteInput<T> setPlaceholder(IDisplayString placeholder) {
        this.inputField.setPlaceholder(placeholder);
        return this;
    }

    @Override
    public DomAutoCompleteInput<T> setFocus(boolean focus) {
        this.inputField.setFocus(focus);
        return this;
    }

    @Override
    public IDomElement setEnabled(boolean enabled) {
        this.getConfiguration().setEnabled(enabled);
        return this.inputField;
    }

    public DomAutoCompleteInput<T> select() {
        this.inputField.select();
        return this;
    }

    public DomAutoCompleteInput<T> setMaxLength(int maxLength) {
        this.inputField.setMaxLength(maxLength);
        return this;
    }

    protected void setInputEngine(IDomAutoCompleteInputEngine<T> inputEngine) {
        this.inputEngine = inputEngine;
        this.refreshFilters();
    }

    protected String getRawValueString() {
        return Optional.ofNullable(this.inputField.getValue()).orElse("");
    }

    private Collection<T> getMatchingItems(String pattern) {
        if (this.sloppyAmbiguityCheck) {
            return this.getMatchingItems(pattern, 2);
        }
        return this.getMatchingItems(pattern, 10);
    }

    private Collection<T> getMatchingItems(String pattern, int limit) {
        if (!pattern.isEmpty()) {
            return this.inputEngine.findMatches(pattern, limit);
        }
        return Collections.emptySet();
    }

    private String getTrimmed(String pattern) {
        return Optional.ofNullable(pattern).map(String::trim).orElse("");
    }

    private String getTrimmedLowerCase(String pattern) {
        return Optional.ofNullable(this.getTrimmed(pattern)).map(String::toLowerCase).orElse("");
    }

    private void refreshInputValidity() {
        this.inputField.setValue(this.inputField.getValue());
        if (!this.getSelection().isValid()) {
            this.getDomEngine().setAutoCompleteInputInvalid(this);
        }
    }

    private void initializeAutoComplete(DomAutoCompleteInputValidationMode defaultMode) {
        this.getDomEngine().enableAutoComplete(this);
        this.initializeEnabledAutoComplete(defaultMode);
    }

    private void initializeEnabledAutoComplete(DomAutoCompleteInputValidationMode defaultMode) {
        if (this.configuration.getValidationMode() != defaultMode) {
            this.configuration.setValidationMode(defaultMode);
        }
    }

    private class InputField
    extends DomTextInput
    implements IDomEventHandler {
        private InputField() {
        }

        @Override
        public void handleDOMEvent(IDomEvent event) {
            if (DomAutoCompleteInput.this.changeCallback != null) {
                DomAutoCompleteInput.this.changeCallback.apply();
            }
        }
    }

    private class CompositeCallback
    implements INullaryVoidFunction {
        private final List<INullaryVoidFunction> callbacks;

        public CompositeCallback(INullaryVoidFunction ... callbacks) {
            this.callbacks = Arrays.asList(callbacks);
        }

        public void apply() {
            this.callbacks.stream().filter(Objects::nonNull).forEach(INullaryVoidFunction::apply);
        }
    }
}

