/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input.auto;

import com.softicar.platform.common.core.exceptions.SofticarUserException;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.DomI18n;
import com.softicar.platform.dom.elements.input.auto.IDomAutoCompleteInputEngine;
import com.softicar.platform.dom.input.auto.IDomAutoCompleteInputConfiguration;
import com.softicar.platform.dom.input.auto.IDomAutoCompleteInputSelection;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

class DomAutoCompleteInputSelection<T>
implements IDomAutoCompleteInputSelection<T> {
    private final IDomAutoCompleteInputEngine<T> inputEngine;
    private final IDomAutoCompleteInputConfiguration configuration;
    private final Collection<T> matchingValues;
    private final String pattern;

    public DomAutoCompleteInputSelection(IDomAutoCompleteInputEngine<T> inputEngine, IDomAutoCompleteInputConfiguration configuration, Function<String, Collection<T>> matchingValuesFunction, String pattern) {
        this.inputEngine = inputEngine;
        this.configuration = configuration;
        this.matchingValues = matchingValuesFunction.apply(pattern.toLowerCase());
        this.pattern = pattern;
    }

    @Override
    public T getValueOrThrow() {
        this.assertValid();
        return this.getMatchingValue().orElse(null);
    }

    @Override
    public T getValueOrNull() {
        return this.getValue().orElse(null);
    }

    @Override
    public Optional<T> getValue() {
        if (this.isValid()) {
            return this.getMatchingValue();
        }
        return Optional.empty();
    }

    @Override
    public void assertValid() {
        if (!this.isValid()) {
            throw new SofticarUserException((IDisplayString)DomI18n.PLEASE_SELECT_A_VALID_ENTRY);
        }
    }

    @Override
    public boolean isValid() {
        if (this.isValueMissing()) {
            return false;
        }
        if (this.isValueEmptyOrModePermissive()) {
            return true;
        }
        return this.isValueValid();
    }

    @Override
    public boolean isBlankPattern() {
        return this.pattern.isEmpty();
    }

    private boolean isValueMissing() {
        return this.configuration.isMandatory() && this.isBlankPattern();
    }

    private boolean isValueValid() {
        if (this.configuration.getValidationMode().isRestrictive()) {
            return this.isPatternInValues(true);
        }
        return this.isValueUnique() || this.isPatternInValues(false);
    }

    private boolean isValueEmptyOrModePermissive() {
        return this.isBlankPattern() || this.configuration.getValidationMode().isPermissive();
    }

    private boolean isValueUnique() {
        return this.matchingValues.size() == 1;
    }

    private boolean isPatternInValues(boolean respectCase) {
        return this.getFirstMatchingValue(respectCase).isPresent();
    }

    private Optional<T> getMatchingValue() {
        if (this.configuration.getValidationMode().isRestrictive()) {
            return this.getFirstMatchingValue(true);
        }
        return this.getDeducedValue();
    }

    private Optional<T> getDeducedValue() {
        Optional<T> matchingValue = this.getSoleMatchingValue();
        if (matchingValue.isPresent()) {
            return matchingValue;
        }
        matchingValue = this.getFirstMatchingValue(true);
        if (matchingValue.isPresent()) {
            return matchingValue;
        }
        return Optional.empty();
    }

    private Optional<T> getSoleMatchingValue() {
        if (this.matchingValues.size() == 1) {
            return Optional.ofNullable(this.matchingValues.iterator().next());
        }
        return Optional.empty();
    }

    private Optional<T> getFirstMatchingValue(boolean respectCase) {
        for (T value : this.matchingValues) {
            if (!this.matchesPattern(value, respectCase)) continue;
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    private boolean matchesPattern(T value, boolean respectCase) {
        return Optional.ofNullable(this.inputEngine.getDisplayString(value)).map(IDisplayString::toString).map(String::trim).map(it -> this.transform((String)it, respectCase)).filter(it -> !it.isEmpty()).filter(it -> it.equals(this.transform(this.pattern, respectCase))).isPresent();
    }

    private String transform(String input, boolean respectCase) {
        return Optional.ofNullable(input).map(respectCase ? it -> it : it -> it.toLowerCase()).orElse("");
    }
}

