/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input.auto;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.dom.elements.input.auto.IDomAutoCompleteInputEngine;
import com.softicar.platform.dom.input.auto.DomAutoCompleteList;
import java.util.Optional;

public class DomAutoCompleteListGenerator<T> {
    private final IDomAutoCompleteInputEngine<T> inputEngine;
    private final int limit;

    public DomAutoCompleteListGenerator(IDomAutoCompleteInputEngine<T> inputEngine, int limit) {
        this.inputEngine = inputEngine;
        this.limit = limit;
    }

    public DomAutoCompleteList generate(String pattern) {
        DomAutoCompleteList list = new DomAutoCompleteList();
        for (T item : this.inputEngine.findMatches(pattern, this.limit)) {
            String displayName = this.getDisplayName(item);
            if (!this.isNotBlank(displayName)) continue;
            list.add(displayName, this.getDescription(item));
        }
        return list;
    }

    private String getDisplayName(T item) {
        return Optional.ofNullable(this.inputEngine.getDisplayString(item)).map(IDisplayString::toString).orElse("");
    }

    private String getDescription(T item) {
        return Optional.ofNullable(this.inputEngine.getDescription(item)).orElse("");
    }

    private boolean isNotBlank(String string) {
        return string != null && !string.trim().isEmpty();
    }
}

