/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input.auto.entity;

import com.softicar.platform.common.core.entity.EntityIdFromDisplayStringExtractor;
import com.softicar.platform.common.core.entity.IEntity;
import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.number.parser.IntegerParser;
import com.softicar.platform.common.core.transaction.ITransaction;
import com.softicar.platform.dom.elements.input.auto.AbstractDomAutoCompletePreferenceInputEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeSet;

public abstract class AbstractDomAutoCompleteTransactionalEntityInputEngine<T extends IEntity>
extends AbstractDomAutoCompletePreferenceInputEngine<T> {
    protected abstract ITransaction createTransaction();

    @Override
    public IDisplayString getDisplayString(T item) {
        return item.toDisplay();
    }

    public IDisplayString getDisplayStringWithoutId(T item) {
        return item.toDisplayWithoutId();
    }

    @Override
    public Collection<T> findMatches(String pattern, int limit) {
        try (ITransaction transaction = this.createTransaction();){
            Collection deduplicatedMatches;
            Collection matches = super.findMatches(pattern, limit);
            Collection collection = deduplicatedMatches = this.getDeduplicated(matches);
            return collection;
        }
    }

    @Override
    public Optional<T> findPerfectMatch(String pattern) {
        T entity;
        Optional<Integer> id;
        if (pattern != null && (id = this.extractId(pattern.trim())).isPresent() && (entity = this.getById(id.get())) != null) {
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    protected Optional<Integer> extractId(String trimmedPattern) {
        Optional id = IntegerParser.parse((String)trimmedPattern);
        if (id.isPresent()) {
            return id;
        }
        return new EntityIdFromDisplayStringExtractor(trimmedPattern).extractId();
    }

    protected abstract T getById(Integer var1);

    private Collection<T> getDeduplicated(Collection<T> items) {
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        TreeSet<IEntity> contained = new TreeSet<IEntity>();
        for (IEntity item : items) {
            if (item == null || contained.contains(item)) continue;
            result.add(item);
            contained.add(item);
        }
        return result;
    }
}

