/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input.auto.entity;

import com.softicar.platform.common.core.entity.IEntity;
import com.softicar.platform.common.core.item.ItemId;
import com.softicar.platform.common.core.transaction.ITransaction;
import com.softicar.platform.dom.elements.input.auto.entity.AbstractDomAutoCompleteTransactionalEntityInputEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DomAutoCompleteEntityInMemoryInputEngine<T extends IEntity>
extends AbstractDomAutoCompleteTransactionalEntityInputEngine<T> {
    private final Map<ItemId, T> itemMap = new TreeMap<ItemId, T>();
    private final List<T> itemList = new ArrayList<T>();

    public DomAutoCompleteEntityInMemoryInputEngine() {
        this(Collections.emptySet());
    }

    public DomAutoCompleteEntityInMemoryInputEngine(Collection<T> items) {
        this.setItems(items);
    }

    @Override
    public T getById(Integer id) {
        return (T)((IEntity)this.itemMap.get(new ItemId((long)id.intValue())));
    }

    @Override
    public Collection<T> findMatchingItems(String pattern, int fetchOffset, int fetchSize) {
        return new ItemLoader(fetchOffset, fetchSize).load(item -> this.getNormalizedDisplayName(item).contains(pattern));
    }

    @Override
    public Optional<T> findPerfectMatch(String pattern) {
        Optional perfectMatch = super.findPerfectMatch(pattern);
        if (perfectMatch.isPresent()) {
            return perfectMatch;
        }
        ItemLoader loader = new ItemLoader(0, 2);
        List items = loader.load(item -> this.getNormalizedDisplayName(item).equals(pattern));
        if (items.size() != 1) {
            items = loader.load(item -> this.getNormalizedDisplayNameWithoutId(item).equals(pattern));
        }
        if (items.size() == 1) {
            return Optional.ofNullable((IEntity)items.iterator().next());
        }
        return Optional.empty();
    }

    @Override
    protected ITransaction createTransaction() {
        return ITransaction.noOperation();
    }

    public void setItems(Collection<T> items) {
        this.clearItems();
        items.forEach(this::addItem);
    }

    public Collection<T> getItems() {
        return Collections.unmodifiableCollection(this.itemList);
    }

    private void clearItems() {
        this.itemMap.clear();
        this.itemList.clear();
    }

    private void addItem(T item) {
        this.itemMap.put(item.getItemId(), item);
        this.itemList.add(item);
    }

    private String getNormalizedDisplayName(T item) {
        return this.getDisplayString(item).toString().toLowerCase();
    }

    private String getNormalizedDisplayNameWithoutId(T item) {
        return this.getDisplayStringWithoutId(item).toString().toLowerCase();
    }

    private class ItemLoader {
        private final int offset;
        private final int limit;

        public ItemLoader(int offset, int limit) {
            this.offset = offset;
            this.limit = limit;
        }

        public List<T> load(Predicate<T> filterPredicate) {
            return DomAutoCompleteEntityInMemoryInputEngine.this.itemList.stream().filter(filterPredicate).skip(this.offset).limit(this.limit).collect(Collectors.toList());
        }
    }
}

