/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.dom.elements.input.auto.string;

import com.softicar.platform.dom.elements.input.auto.string.AbstractDomAutoCompleteStringInputEngine;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DomAutoCompleteStringInMemoryInputEngine
extends AbstractDomAutoCompleteStringInputEngine {
    private final Map<String, String> items = new TreeMap<String, String>();

    public DomAutoCompleteStringInMemoryInputEngine() {
        this(Collections.emptySet());
    }

    public DomAutoCompleteStringInMemoryInputEngine(Collection<String> items) {
        items.forEach(this::addItem);
    }

    @Override
    public Collection<String> findMatchingItems(String pattern, int fetchOffset, int fetchSize) {
        return new ItemLoader(fetchOffset, fetchSize).load(item -> this.getNormalizedDisplayName((String)item).contains(pattern));
    }

    @Override
    public Optional<String> findPerfectMatch(String pattern) {
        List<String> items = new ItemLoader(0, 2).load(item -> this.getNormalizedDisplayName((String)item).equals(pattern));
        if (items.size() == 1) {
            return Optional.of(items.iterator().next());
        }
        return Optional.empty();
    }

    public void addItem(String item) {
        this.addItem(item, null);
    }

    public void addItem(String item, String description) {
        this.items.put(item, description);
    }

    public void setItems(Collection<String> items) {
        this.items.clear();
        items.forEach(this::addItem);
    }

    public void setItems(Map<String, String> items) {
        this.items.clear();
        this.items.putAll(items);
    }

    public Map<String, String> getItems() {
        return Collections.unmodifiableMap(this.items);
    }

    private String getNormalizedDisplayName(String item) {
        return this.getDisplayString(item).toString().toLowerCase();
    }

    private class ItemLoader {
        private final int offset;
        private final int limit;

        public ItemLoader(int offset, int limit) {
            this.offset = offset;
            this.limit = limit;
        }

        public List<String> load(Predicate<String> filterPredicate) {
            return DomAutoCompleteStringInMemoryInputEngine.this.items.keySet().stream().filter(filterPredicate).skip(this.offset).limit(this.limit).collect(Collectors.toList());
        }
    }
}

